/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe310.classes.NFNotaInfoSituacaoTributariaPIS;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoPISAliquota
extends DFBase {
    private static final long serialVersionUID = 4109084296960847091L;
    private static final List<NFNotaInfoSituacaoTributariaPIS> SITUACOES_VALIDAS = Arrays.asList(NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_CUMULATIVO_NAO_CUMULATIVO, NFNotaInfoSituacaoTributariaPIS.OPERACAO_TRIBUTAVEL_ALIQUOTA_DIFERENCIADA);
    @Element(name="CST")
    private NFNotaInfoSituacaoTributariaPIS situacaoTributaria = null;
    @Element(name="vBC")
    private String valorBaseCalculo = null;
    @Element(name="pPIS")
    private String percentualAliquota = null;
    @Element(name="vPIS")
    private String valorTributo = null;

    public void setSituacaoTributaria(NFNotaInfoSituacaoTributariaPIS nFNotaInfoSituacaoTributariaPIS) {
        if (!SITUACOES_VALIDAS.contains((Object)nFNotaInfoSituacaoTributariaPIS)) {
            throw new IllegalStateException("Situacao tributaria invalida no item PIS aliquota");
        }
        this.situacaoTributaria = nFNotaInfoSituacaoTributariaPIS;
    }

    public void setValorBaseCalculo(BigDecimal bigDecimal) {
        this.valorBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC PIS Item");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Aliquota PIS Item");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor PIS Item");
    }

    public NFNotaInfoSituacaoTributariaPIS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getValorBaseCalculo() {
        return this.valorBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }
}

