/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.evento.NFEnviaEventoRetorno;
import com.fincatto.documentofiscal.nfe310.classes.evento.NFEvento;
import com.fincatto.documentofiscal.nfe310.classes.evento.NFInfoEvento;
import com.fincatto.documentofiscal.nfe310.classes.evento.NFTipoEvento;
import com.fincatto.documentofiscal.nfe310.classes.evento.cartacorrecao.NFEnviaEventoCartaCorrecao;
import com.fincatto.documentofiscal.nfe310.parsers.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.RecepcaoEventoStub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.time.ZonedDateTime;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSCartaCorrecao
implements DFLog {
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private static final String EVENTO_CODIGO = "110110";
    private static final String EVENTO_DESCRICAO = "Carta de Correcao";
    private static final String EVENTO_CONDICAO_USO = "A Carta de Correcao e disciplinada pelo paragrafo 1o-A do art. 7o do Convenio S/N, de 15 de dezembro de 1970 e pode ser utilizada para regularizacao de erro ocorrido na emissao de documento fiscal, desde que o erro nao esteja relacionado com: I - as variaveis que determinam o valor do imposto tais como: base de calculo, aliquota, diferenca de preco, quantidade, valor da operacao ou da prestacao; II - a correcao de dados cadastrais que implique mudanca do remetente ou do destinatario; III - a data de emissao ou de saida.";
    private final NFeConfig config;

    WSCartaCorrecao(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFEnviaEventoRetorno corrigeNota(String string, String string2, int n) throws Exception {
        String string3 = this.gerarDadosCartaCorrecao(string, string2, n).toString();
        String string4 = new DFAssinaturaDigital(this.config).assinarDocumento(string3);
        OMElement oMElement = this.efetuaCorrecao(string4, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    NFEnviaEventoRetorno corrigeNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaCorrecao(string2, string);
        return (NFEnviaEventoRetorno)this.config.getPersister().read(NFEnviaEventoRetorno.class, oMElement.toString());
    }

    private OMElement efetuaCorrecao(String string, String string2) throws XMLStreamException, RemoteException {
        String string3;
        RecepcaoEventoStub.NfeCabecMsg nfeCabecMsg = new RecepcaoEventoStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(VERSAO_LEIAUTE.toPlainString());
        RecepcaoEventoStub.NfeCabecMsgE nfeCabecMsgE = new RecepcaoEventoStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        RecepcaoEventoStub.NfeDadosMsg nfeDadosMsg = new RecepcaoEventoStub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string2);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfCodigoUF(this.config.getCUF());
        String string4 = string3 = DFModelo.NFCE.equals((Object)notaFiscalChaveParser.getModelo()) ? nFAutorizador31.getNfceRecepcaoEvento(this.config.getAmbiente()) : nFAutorizador31.getRecepcaoEvento(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + notaFiscalChaveParser.getModelo().name() + ", autorizador " + nFAutorizador31.name());
        }
        RecepcaoEventoStub.NfeRecepcaoEventoResult nfeRecepcaoEventoResult = new RecepcaoEventoStub(string3, this.config).nfeRecepcaoEvento(nfeDadosMsg, nfeCabecMsgE);
        OMElement oMElement2 = nfeRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private NFEnviaEventoCartaCorrecao gerarDadosCartaCorrecao(String string, String string2, int n) {
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        NFTipoEvento nFTipoEvento = new NFTipoEvento();
        nFTipoEvento.setVersao(VERSAO_LEIAUTE);
        nFTipoEvento.setDescricaoEvento(EVENTO_DESCRICAO);
        nFTipoEvento.setCondicaoUso(EVENTO_CONDICAO_USO);
        nFTipoEvento.setTextoCorrecao(string2);
        NFInfoEvento nFInfoEvento = new NFInfoEvento();
        nFInfoEvento.setAmbiente(this.config.getAmbiente());
        nFInfoEvento.setDadosEvento(nFTipoEvento);
        nFInfoEvento.setChave(string);
        nFInfoEvento.setCnpj(notaFiscalChaveParser.getCnpjEmitente());
        nFInfoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        nFInfoEvento.setId(String.format("ID%s%s%02d", EVENTO_CODIGO, string, n));
        nFInfoEvento.setNumeroSequencialEvento(n);
        nFInfoEvento.setOrgao(notaFiscalChaveParser.getNFUnidadeFederativa());
        nFInfoEvento.setTipoEvento(EVENTO_CODIGO);
        nFInfoEvento.setVersaoEvento(VERSAO_LEIAUTE);
        NFEvento nFEvento = new NFEvento();
        nFEvento.setInfoEvento(nFInfoEvento);
        nFEvento.setVersao(VERSAO_LEIAUTE);
        NFEnviaEventoCartaCorrecao nFEnviaEventoCartaCorrecao = new NFEnviaEventoCartaCorrecao();
        nFEnviaEventoCartaCorrecao.setEvento(Collections.singletonList(nFEvento));
        nFEnviaEventoCartaCorrecao.setIdLote(Long.toString(ZonedDateTime.now(this.config.getTimeZone().toZoneId()).toInstant().toEpochMilli()));
        nFEnviaEventoCartaCorrecao.setVersao(VERSAO_LEIAUTE);
        return nFEnviaEventoCartaCorrecao;
    }
}

