/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoItemModalidadeBCICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS51
extends DFBase {
    private static final long serialVersionUID = -5575047808092974601L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="modBC", required=false)
    private NFNotaInfoItemModalidadeBCICMS modalidadeBCICMS;
    @Element(name="pRedBC", required=false)
    private String percentualReducaoBC;
    @Element(name="cBenefRBC", required=false)
    private String codigoBeneficioFiscalRBC;
    @Element(name="vBC", required=false)
    private String valorBCICMS;
    @Element(name="pICMS", required=false)
    private String percentualICMS;
    @Element(name="vICMSOp", required=false)
    private String valorICMSOperacao;
    @Element(name="pDif", required=false)
    private String percentualDiferimento;
    @Element(name="vICMSDif", required=false)
    private String valorICMSDiferimento;
    @Element(name="vICMS", required=false)
    private String valorICMS;
    @Element(name="vBCFCP", required=false)
    private String valorBCFundoCombatePobreza;
    @Element(name="pFCP", required=false)
    private String percentualFundoCombatePobreza;
    @Element(name="vFCP", required=false)
    private String valorFundoCombatePobreza;
    @Element(name="pFCPDif", required=false)
    private String percentualDiferimentoFundoCombatePobreza;
    @Element(name="vFCPDif", required=false)
    private String valorDiferimentoFundoCombatePobreza;
    @Element(name="vFCPEfet", required=false)
    private String valorEfetivoFundoCombatePobreza;

    public String getPercentualDiferimentoFundoCombatePobreza() {
        return this.percentualDiferimentoFundoCombatePobreza;
    }

    public void setPercentualDiferimentoFundoCombatePobreza(BigDecimal bigDecimal) {
        if (bigDecimal.signum() < 0) {
            throw new IllegalStateException("Percentual diferimento fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualDiferimentoFundoCombatePobreza = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual diferimento fundo combate pobreza");
    }

    public String getValorDiferimentoFundoCombatePobreza() {
        return this.valorDiferimentoFundoCombatePobreza;
    }

    public void setValorDiferimentoFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorDiferimentoFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor diferimento fundo combate pobreza");
    }

    public String getValorEfetivoFundoCombatePobreza() {
        return this.valorEfetivoFundoCombatePobreza;
    }

    public void setValorEfetivoFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorEfetivoFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor efetivo fundo combate pobreza");
    }

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setModalidadeBCICMS(NFNotaInfoItemModalidadeBCICMS nFNotaInfoItemModalidadeBCICMS) {
        this.modalidadeBCICMS = nFNotaInfoItemModalidadeBCICMS;
    }

    public void setPercentualReducaoBC(BigDecimal bigDecimal) {
        this.percentualReducaoBC = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Reducao BC ICMS51 Item");
    }

    public void setValorBCICMS(BigDecimal bigDecimal) {
        this.valorBCICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor BC ICMS ICMS51 Item");
    }

    public void setPercentualICMS(BigDecimal bigDecimal) {
        this.percentualICMS = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual ICMS ICMS51 Item");
    }

    public void setValorICMS(BigDecimal bigDecimal) {
        this.valorICMS = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS ICMS51 Item");
    }

    public void setPercentualDiferimento(BigDecimal bigDecimal) {
        this.percentualDiferimento = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual Diferimento ICMS51 Item");
    }

    public void setValorICMSDiferimento(BigDecimal bigDecimal) {
        this.valorICMSDiferimento = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Diferimento ICMS51 Item");
    }

    public void setValorICMSOperacao(BigDecimal bigDecimal) {
        this.valorICMSOperacao = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor ICMS Operacao ICMS51 Item");
    }

    public void setValorBCFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorBCFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor base calculo fundo combate pobreza");
    }

    public void setPercentualFundoCombatePobreza(BigDecimal bigDecimal) {
        if (bigDecimal.signum() < 0) {
            throw new IllegalStateException("Percentual fundo de combate a pobreza precisa ser maior que zero!");
        }
        this.percentualFundoCombatePobreza = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Percentual fundo combate pobreza");
    }

    public void setValorFundoCombatePobreza(BigDecimal bigDecimal) {
        this.valorFundoCombatePobreza = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor fundo combate pobreza");
    }

    public void setCodigoBeneficioFiscalRBC(String string) {
        this.codigoBeneficioFiscalRBC = DFStringValidador.validador(string, "Codigo Beneficio Fiscal RBC", 10, false, false);
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public NFNotaInfoItemModalidadeBCICMS getModalidadeBCICMS() {
        return this.modalidadeBCICMS;
    }

    public String getPercentualReducaoBC() {
        return this.percentualReducaoBC;
    }

    public String getValorBCICMS() {
        return this.valorBCICMS;
    }

    public String getPercentualICMS() {
        return this.percentualICMS;
    }

    public String getValorICMSOperacao() {
        return this.valorICMSOperacao;
    }

    public String getPercentualDiferimento() {
        return this.percentualDiferimento;
    }

    public String getValorICMSDiferimento() {
        return this.valorICMSDiferimento;
    }

    public String getValorICMS() {
        return this.valorICMS;
    }

    public String getValorBCFundoCombatePobreza() {
        return this.valorBCFundoCombatePobreza;
    }

    public String getPercentualFundoCombatePobreza() {
        return this.percentualFundoCombatePobreza;
    }

    public String getValorFundoCombatePobreza() {
        return this.valorFundoCombatePobreza;
    }

    public String getCodigoBeneficioFiscalRBC() {
        return this.codigoBeneficioFiscalRBC;
    }
}

