/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.nfe400.classes.NFNotaInfoImpostoTributacaoICMS;
import com.fincatto.documentofiscal.nfe400.classes.NFOrigem;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemImpostoICMS61
extends DFBase {
    private static final long serialVersionUID = -8806839168760474001L;
    @Element(name="orig")
    private NFOrigem origem;
    @Element(name="CST")
    private NFNotaInfoImpostoTributacaoICMS situacaoTributaria;
    @Element(name="qBCMonoRet", required=false)
    private String quantidadeBaseCalculo;
    @Element(name="adRemICMSRet")
    private String percentualAliquota;
    @Element(name="vICMSMonoRet")
    private String valorTributo;

    public void setOrigem(NFOrigem nFOrigem) {
        this.origem = nFOrigem;
    }

    public void setSituacaoTributaria(NFNotaInfoImpostoTributacaoICMS nFNotaInfoImpostoTributacaoICMS) {
        if (!nFNotaInfoImpostoTributacaoICMS.equals((Object)NFNotaInfoImpostoTributacaoICMS.CST_61)) {
            throw new IllegalStateException("Situacao tributaria invalida no item ICMS61 ");
        }
        this.situacaoTributaria = nFNotaInfoImpostoTributacaoICMS;
    }

    public void setQuantidadeBaseCalculo(BigDecimal bigDecimal) {
        this.quantidadeBaseCalculo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Quantidade tributada retida anteriormente");
    }

    public void setPercentualAliquota(BigDecimal bigDecimal) {
        this.percentualAliquota = DFBigDecimalValidador.tamanho7ComAte4CasasDecimais(bigDecimal, "Al\u00edquota ad rem do imposto retido anteriormente");
    }

    public void setValorTributo(BigDecimal bigDecimal) {
        this.valorTributo = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "ICMS retido anteriormente");
    }

    public NFOrigem getOrigem() {
        return this.origem;
    }

    public NFNotaInfoImpostoTributacaoICMS getSituacaoTributaria() {
        return this.situacaoTributaria;
    }

    public String getQuantidadeBaseCalculo() {
        return this.quantidadeBaseCalculo;
    }

    public String getPercentualAliquota() {
        return this.percentualAliquota;
    }

    public String getValorTributo() {
        return this.valorTributo;
    }
}

