/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFBigIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoDeclaracaoImportacaoAdicao
extends DFBase {
    private static final long serialVersionUID = -7286071184901675008L;
    @Element(name="nAdicao")
    private Integer numero;
    @Element(name="nSeqAdic")
    private Integer sequencial;
    @Element(name="cFabricante")
    private String codigoFabricante;
    @Element(name="vDescDI", required=false)
    private String desconto;
    @Element(name="nDraw", required=false)
    private BigInteger numeroAtoConcessorioDrawback;

    public void setNumero(Integer n) {
        DFIntegerValidador.tamanho3(n, "Numero Declaracao Importacao Adicao");
        this.numero = n;
    }

    public void setSequencial(Integer n) {
        DFIntegerValidador.tamanho3(n, "Sequencial Declaracao Importacao Adicao");
        this.sequencial = n;
    }

    public void setCodigoFabricante(String string) {
        DFStringValidador.tamanho60(string, "Codigo Fabricante Declaracao Importacao Adicao");
        this.codigoFabricante = string;
    }

    public void setDesconto(BigDecimal bigDecimal) {
        this.desconto = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Desconto Declaracao Importacao Adicao");
    }

    public void setNumeroAtoConcessorioDrawback(BigInteger bigInteger) {
        DFBigIntegerValidador.tamanho11(bigInteger, "Numero Ato Concessorio Declaracao Importacao Adicao");
        this.numeroAtoConcessorioDrawback = bigInteger;
    }

    public Integer getNumero() {
        return this.numero;
    }

    public Integer getSequencial() {
        return this.sequencial;
    }

    public String getCodigoFabricante() {
        return this.codigoFabricante;
    }

    public String getDesconto() {
        return this.desconto;
    }

    public BigInteger getNumeroAtoConcessorioDrawback() {
        return this.numeroAtoConcessorioDrawback;
    }
}

