/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices.comprovanteentrega;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.webservices.gerado.NFeRecepcaoEvento4Stub;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

public abstract class WSBaseComprovanteEntrega
implements DFLog {
    private final NFeConfig config;
    private final BigDecimal VERSAO_LEIAUTE = new BigDecimal("1.00");
    private final String URL_HOMOLOGACAO = "https://hom1.nfe.fazenda.gov.br/NFeRecepcaoEvento4/NFeRecepcaoEvento4.asmx";
    private final String URL_PRODUCAO = "https://www.nfe.fazenda.gov.br/NFeRecepcaoEvento4/NFeRecepcaoEvento4.asmx";

    public WSBaseComprovanteEntrega(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    protected OMElement efetuaEnvio(String string) throws XMLStreamException, RemoteException {
        NFeRecepcaoEvento4Stub.NfeDadosMsg nfeDadosMsg = new NFeRecepcaoEvento4Stub.NfeDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        nfeDadosMsg.setExtraElement(oMElement);
        NFeRecepcaoEvento4Stub.NfeResultMsg nfeResultMsg = new NFeRecepcaoEvento4Stub(this.getUrl(), this.config).nfeRecepcaoEvento(nfeDadosMsg);
        OMElement oMElement2 = nfeResultMsg.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    private String getUrl() {
        if (this.config.getAmbiente() != null && this.config.getAmbiente().equals((Object)DFAmbiente.PRODUCAO)) {
            return "https://www.nfe.fazenda.gov.br/NFeRecepcaoEvento4/NFeRecepcaoEvento4.asmx";
        }
        return "https://hom1.nfe.fazenda.gov.br/NFeRecepcaoEvento4/NFeRecepcaoEvento4.asmx";
    }

    protected String assinarDocumento(String string) throws Exception {
        return new DFAssinaturaDigital(this.config).assinarDocumento(string);
    }

    protected NFeConfig getConfig() {
        return this.config;
    }

    protected BigDecimal getVersao() {
        return this.VERSAO_LEIAUTE;
    }
}

