/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.webservices.comprovanteentrega;

import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe400.NotaFiscalChaveParser;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.envio.NFComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.envio.envio.NFEnvComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.classes.nota.comprovanteentrega.retorno.NFRetornoEvtComprovanteEntrega;
import com.fincatto.documentofiscal.nfe400.webservices.comprovanteentrega.WSBaseComprovanteEntrega;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.axiom.om.OMElement;

public class WSEventoComprovanteEntrega
extends WSBaseComprovanteEntrega {
    private static final String EVENTO_CODIGO = "110130";

    public WSEventoComprovanteEntrega(NFeConfig nFeConfig) {
        super(nFeConfig);
    }

    public NFRetornoEvtComprovanteEntrega enviaComprovante(String string, NFEnvComprovanteEntrega nFEnvComprovanteEntrega, int n) throws Exception {
        String string2 = this.getXmlAssinado(string, nFEnvComprovanteEntrega, n);
        OMElement oMElement = this.efetuaEnvio(string2);
        return (NFRetornoEvtComprovanteEntrega)this.getConfig().getPersister().read(NFRetornoEvtComprovanteEntrega.class, oMElement.toString());
    }

    public String getXmlAssinado(String string, NFEnvComprovanteEntrega nFEnvComprovanteEntrega, int n) throws Exception {
        String string2 = this.complementarDadosEvento(string, nFEnvComprovanteEntrega, n).toString();
        return this.assinarDocumento(string2);
    }

    public NFEnvComprovanteEntrega complementarDadosEvento(String string, NFEnvComprovanteEntrega nFEnvComprovanteEntrega, int n) {
        NotaFiscalChaveParser notaFiscalChaveParser = new NotaFiscalChaveParser(string);
        nFEnvComprovanteEntrega.setVersao(this.getVersao().toString());
        nFEnvComprovanteEntrega.setIdLote("1");
        List<NFComprovanteEntrega> list = nFEnvComprovanteEntrega.getEvento();
        if (list != null) {
            for (NFComprovanteEntrega nFComprovanteEntrega : list) {
                nFComprovanteEntrega.setVersao(this.getVersao());
                if (nFComprovanteEntrega.getInfEvento() == null) continue;
                nFComprovanteEntrega.getInfEvento().setAmbiente(this.getConfig().getAmbiente());
                nFComprovanteEntrega.getInfEvento().setChaveAcessoNFe(string);
                if (Integer.parseInt(notaFiscalChaveParser.getSerie()) >= 920 && Integer.parseInt(notaFiscalChaveParser.getSerie()) <= 969) {
                    nFComprovanteEntrega.getInfEvento().setCpf(notaFiscalChaveParser.getCpfEmitente());
                } else {
                    nFComprovanteEntrega.getInfEvento().setCnpj(notaFiscalChaveParser.getCnpjEmitente());
                }
                nFComprovanteEntrega.getInfEvento().setDataEvento(ZonedDateTime.now(this.getConfig().getTimeZone().toZoneId()));
                nFComprovanteEntrega.getInfEvento().setId(String.format("ID%s%s%02d", EVENTO_CODIGO, string, n));
                nFComprovanteEntrega.getInfEvento().setNumSeqEvento(n);
                nFComprovanteEntrega.getInfEvento().setOrgao(DFUnidadeFederativa.RFB);
                nFComprovanteEntrega.getInfEvento().setTipoEvento(EVENTO_CODIGO);
                nFComprovanteEntrega.getInfEvento().setVerEvento(this.getVersao());
                nFComprovanteEntrega.getInfEvento().getDetalhesEvento().setVersao(this.getVersao());
            }
        }
        return nFEnvComprovanteEntrega;
    }
}

