/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.utils;

import java.util.Arrays;
import java.util.List;

public abstract class DFUtils {
    private static final List<String> CPFS_INVALIDOS = Arrays.asList("00000000000", "11111111111", "22222222222", "33333333333", "44444444444", "55555555555", "66666666666", "77777777777", "88888888888", "99999999999", "12345678909");

    public static boolean isCnpjValido(String string) {
        int n;
        int n2;
        if (string == null || !string.matches("^[0-9]{14}$")) {
            return false;
        }
        if (string.equalsIgnoreCase("00000000000000")) {
            return false;
        }
        Object object = string.substring(0, 12);
        char[] cArray = string.toCharArray();
        int n3 = 0;
        for (n2 = 0; n2 < 4; ++n2) {
            if (cArray[n2] - 48 < 0 || cArray[n2] - 48 > 9) continue;
            n3 += (cArray[n2] - 48) * (6 - (n2 + 1));
        }
        for (n2 = 0; n2 < 8; ++n2) {
            if (cArray[n2 + 4] - 48 < 0 || cArray[n2 + 4] - 48 > 9) continue;
            n3 += (cArray[n2 + 4] - 48) * (10 - (n2 + 1));
        }
        n2 = 11 - n3 % 11;
        object = (String)object + (n2 == 10 || n2 == 11 ? "0" : Integer.toString(n2));
        n3 = 0;
        for (n = 0; n < 5; ++n) {
            if (cArray[n] - 48 < 0 || cArray[n] - 48 > 9) continue;
            n3 += (cArray[n] - 48) * (7 - (n + 1));
        }
        for (n = 0; n < 8; ++n) {
            if (cArray[n + 5] - 48 < 0 || cArray[n + 5] - 48 > 9) continue;
            n3 += (cArray[n + 5] - 48) * (10 - (n + 1));
        }
        n2 = 11 - n3 % 11;
        object = (String)object + (n2 == 10 || n2 == 11 ? "0" : Integer.toString(n2));
        return string.equals(object);
    }

    public static boolean isCpfValido(String string) {
        int n;
        int n2;
        if (string == null || !string.matches("^[0-9]{11}$")) {
            return false;
        }
        if (CPFS_INVALIDOS.contains(string)) {
            return false;
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 1; n2 < 10; ++n2) {
            n = Integer.parseInt(string.substring(n2 - 1, n2));
            n3 += (11 - n2) * n;
            n4 += (12 - n2) * n;
        }
        n2 = n3 % 11;
        n = n2 < 2 ? 0 : 11 - n2;
        n2 = (n4 + 2 * n) % 11;
        int n5 = n2 < 2 ? 0 : 11 - n2;
        String string2 = string.substring(string.length() - 2);
        String string3 = String.valueOf(n) + n5;
        return string2.equals(string3);
    }

    public static boolean isNumerico(String string) {
        return string != null && string.matches("\\d+");
    }
}

