/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint;

import am.ik.yavi.constraint.base.ContainerConstraintBase;
import am.ik.yavi.constraint.charsequence.ByteSizeConstraint;
import am.ik.yavi.constraint.charsequence.CodePoints;
import am.ik.yavi.constraint.charsequence.CodePointsConstraint;
import am.ik.yavi.constraint.charsequence.EmojiConstraint;
import am.ik.yavi.constraint.charsequence.variant.VariantOptions;
import am.ik.yavi.constraint.inetaddress.InetAddressUtils;
import am.ik.yavi.constraint.password.CharSequencePasswordPoliciesBuilder;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;

public class CharSequenceConstraint<T, E extends CharSequence>
extends ContainerConstraintBase<T, E, CharSequenceConstraint<T, E>> {
    private static final String EMAIL_PART = "[^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]";
    private static final String DOMAIN_PATTERN = "[^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]+(\\.[^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]+)*";
    private static final Pattern VALID_EMAIL_ADDRESS_REGEX = Pattern.compile("^[^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]+(\\.[^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]+)*@([^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]+(\\.[^\\x00-\\x1F()<>@,;:\\\\\".\\[\\]\\s]+)*|^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$)$", 2);
    private static final Pattern VALID_UUID_REGEX = Pattern.compile("\\p{XDigit}{8}(-\\p{XDigit}{4}){4}\\p{XDigit}{8}");
    protected final Normalizer.Form normalizerForm;
    protected final VariantOptions variantOptions;

    public CharSequenceConstraint() {
        this(Normalizer.Form.NFC, VariantOptions.builder().build());
    }

    public CharSequenceConstraint(Normalizer.Form normalizerForm, VariantOptions variantOptions) {
        this.normalizerForm = normalizerForm;
        this.variantOptions = variantOptions;
    }

    public ByteSizeConstraint<T, E> asByteArray(Charset charset) {
        return new ByteSizeConstraint(this, charset);
    }

    public ByteSizeConstraint<T, E> asByteArray() {
        return this.asByteArray(StandardCharsets.UTF_8);
    }

    @Override
    public CharSequenceConstraint<T, E> cast() {
        return this;
    }

    public CodePointsConstraint.Builder<T, E> codePoints(CodePoints<E> codePoints) {
        return new CodePointsConstraint.Builder(this, codePoints);
    }

    public CodePointsConstraint.Builder<T, E> codePoints(Set<Integer> allowedCodePoints) {
        return this.codePoints(() -> allowedCodePoints);
    }

    public CodePointsConstraint.Builder<T, E> codePoints(int begin, int end) {
        return this.codePoints(CodePoints.Range.of(begin, end), new CodePoints.Range[0]);
    }

    public CodePointsConstraint.Builder<T, E> codePoints(CodePoints.Range range, CodePoints.Range ... ranges) {
        return this.codePoints(() -> {
            ArrayList<CodePoints.Range> list = new ArrayList<CodePoints.Range>();
            list.add(range);
            list.addAll(Arrays.asList(ranges));
            return list;
        });
    }

    public CharSequenceConstraint<T, E> contains(CharSequence s) {
        this.predicates().add(ConstraintPredicate.of(x -> x.toString().contains(s), ViolationMessage.Default.CHAR_SEQUENCE_CONTAINS, () -> new Object[]{s}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> startsWith(CharSequence prefix) {
        this.predicates().add(ConstraintPredicate.of(x -> x.toString().startsWith(prefix.toString()), ViolationMessage.Default.CHAR_SEQUENCE_STARTSWITH, () -> new Object[]{prefix}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> endsWith(CharSequence suffix) {
        this.predicates().add(ConstraintPredicate.of(x -> x.toString().endsWith(suffix.toString()), ViolationMessage.Default.CHAR_SEQUENCE_ENDSWITH, () -> new Object[]{suffix}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> email() {
        this.predicates().add(ConstraintPredicate.of(x -> {
            if (this.size().applyAsInt(x) == 0) {
                return true;
            }
            return VALID_EMAIL_ADDRESS_REGEX.matcher((CharSequence)x).matches();
        }, ViolationMessage.Default.CHAR_SEQUENCE_EMAIL, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> password(Function<CharSequencePasswordPoliciesBuilder<T, E>, List<ConstraintPredicate<E>>> builder) {
        List<ConstraintPredicate<E>> predicates = builder.apply(new CharSequencePasswordPoliciesBuilder());
        this.predicates().addAll(predicates);
        return this;
    }

    private <U> CharSequenceConstraint<T, E> isValidRepresentationOf(Function<String, U> converter, ViolationMessage message) {
        this.predicates().add(ConstraintPredicate.of(x -> {
            if (this.size().applyAsInt(x) == 0) {
                return true;
            }
            try {
                converter.apply(x.toString());
                return true;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }, message, () -> new Object[0], NullAs.VALID));
        return this;
    }

    private CharSequenceConstraint<T, E> isLocalDatePattern(String pattern) {
        this.predicates().add(ConstraintPredicate.of(x -> {
            try {
                DateTimeFormatter.ofPattern(pattern).withResolverStyle(ResolverStyle.STRICT).parse((CharSequence)x);
                return true;
            }
            catch (DateTimeParseException ignored) {
                return false;
            }
        }, ViolationMessage.Default.CHAR_SEQUENCE_LOCAL_DATE, () -> new Object[]{pattern}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> isByte() {
        return this.isValidRepresentationOf(Byte::parseByte, ViolationMessage.Default.CHAR_SEQUENCE_BYTE);
    }

    public CharSequenceConstraint<T, E> isShort() {
        return this.isValidRepresentationOf(Short::parseShort, ViolationMessage.Default.CHAR_SEQUENCE_SHORT);
    }

    public CharSequenceConstraint<T, E> isInteger() {
        return this.isValidRepresentationOf(Integer::parseInt, ViolationMessage.Default.CHAR_SEQUENCE_INTEGER);
    }

    public CharSequenceConstraint<T, E> isLong() {
        return this.isValidRepresentationOf(Long::parseLong, ViolationMessage.Default.CHAR_SEQUENCE_LONG);
    }

    public CharSequenceConstraint<T, E> isFloat() {
        return this.isValidRepresentationOf(Float::parseFloat, ViolationMessage.Default.CHAR_SEQUENCE_FLOAT);
    }

    public CharSequenceConstraint<T, E> isDouble() {
        return this.isValidRepresentationOf(Double::parseDouble, ViolationMessage.Default.CHAR_SEQUENCE_DOUBLE);
    }

    public CharSequenceConstraint<T, E> isBigInteger() {
        return this.isValidRepresentationOf(BigInteger::new, ViolationMessage.Default.CHAR_SEQUENCE_BIGINTEGER);
    }

    public CharSequenceConstraint<T, E> isBigDecimal() {
        return this.isValidRepresentationOf(BigDecimal::new, ViolationMessage.Default.CHAR_SEQUENCE_BIGDECIMAL);
    }

    public CharSequenceConstraint<T, E> isoLocalDate() {
        return this.isLocalDatePattern("uuuu-MM-dd");
    }

    public CharSequenceConstraint<T, E> localDate(String pattern) {
        return this.isLocalDatePattern(pattern);
    }

    public EmojiConstraint<T, E> emoji() {
        return new EmojiConstraint(this, this.normalizerForm, this.variantOptions);
    }

    public CharSequenceConstraint<T, E> normalizer(Normalizer.Form normalizerForm) {
        CharSequenceConstraint<T, E> constraint = new CharSequenceConstraint<T, E>(normalizerForm, this.variantOptions);
        constraint.predicates().addAll(this.predicates());
        return constraint;
    }

    public CharSequenceConstraint<T, E> notBlank() {
        this.predicates().add(ConstraintPredicate.of(x -> x != null && CharSequenceConstraint.trim(x.toString()).length() != 0, ViolationMessage.Default.CHAR_SEQUENCE_NOT_BLANK, () -> new Object[0], NullAs.INVALID));
        return this;
    }

    public CharSequenceConstraint<T, E> pattern(String regex) {
        this.predicates().add(ConstraintPredicate.of(x -> Pattern.matches(regex, x), ViolationMessage.Default.CHAR_SEQUENCE_PATTERN, () -> new Object[]{regex}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> pattern(Pattern regex) {
        this.predicates().add(ConstraintPredicate.of(x -> regex.matcher((CharSequence)x).matches(), ViolationMessage.Default.CHAR_SEQUENCE_PATTERN, () -> new Object[]{regex.pattern()}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> pattern(Supplier<Pattern> regexSupplier) {
        this.predicates().add(ConstraintPredicate.of(x -> ((Pattern)regexSupplier.get()).matcher((CharSequence)x).matches(), ViolationMessage.Default.CHAR_SEQUENCE_PATTERN, () -> new Object[]{((Pattern)regexSupplier.get()).pattern()}, NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> ipv4() {
        this.predicates().add(ConstraintPredicate.of(x -> InetAddressUtils.isIpv4(x.toString()), ViolationMessage.Default.CHAR_SEQUENCE_IPV4, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> ipv6() {
        this.predicates().add(ConstraintPredicate.of(x -> InetAddressUtils.isIpv6(x.toString()), ViolationMessage.Default.CHAR_SEQUENCE_IPV6, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> url() {
        this.predicates().add(ConstraintPredicate.of(x -> {
            if (this.size().applyAsInt(x) == 0) {
                return true;
            }
            try {
                new URL(x.toString());
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }, ViolationMessage.Default.CHAR_SEQUENCE_URL, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> uuid() {
        this.predicates().add(ConstraintPredicate.of(x -> {
            if (this.size().applyAsInt(x) == 0) {
                return true;
            }
            return VALID_UUID_REGEX.matcher((CharSequence)x).matches();
        }, ViolationMessage.Default.CHAR_SEQUENCE_UUID, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CharSequenceConstraint<T, E> luhn() {
        this.predicates().add(ConstraintPredicate.of(CharSequenceConstraint::luhnCheck, ViolationMessage.Default.CHAR_SEQUENCE_LUHN, () -> new Object[0], NullAs.VALID));
        return this;
    }

    static boolean luhnCheck(CharSequence cardNumber) {
        int digits = cardNumber.length();
        int oddOrEven = digits & 1;
        long sum = 0L;
        for (int count = 0; count < digits; ++count) {
            int digit;
            try {
                digit = Integer.parseInt(cardNumber.charAt(count) + "");
            }
            catch (NumberFormatException e) {
                return false;
            }
            if ((count & 1 ^ oddOrEven) == 0 && (digit *= 2) > 9) {
                digit -= 9;
            }
            sum += (long)digit;
        }
        return sum != 0L && sum % 10L == 0L;
    }

    public CharSequenceConstraint<T, E> variant(Function<VariantOptions.Builder, VariantOptions.Builder> opts) {
        VariantOptions.Builder builder = VariantOptions.builder();
        CharSequenceConstraint<T, E> constraint = new CharSequenceConstraint<T, E>(this.normalizerForm, opts.apply(builder).build());
        constraint.predicates().addAll(this.predicates());
        return constraint;
    }

    protected String normalize(String s) {
        String str = this.variantOptions.ignored(s);
        return this.normalizerForm == null ? str : Normalizer.normalize(str, this.normalizerForm);
    }

    @Override
    protected ToIntFunction<E> size() {
        return cs -> {
            String s = this.normalize(cs.toString());
            return s.codePointCount(0, s.length());
        };
    }

    private static String trim(String s) {
        if (s.length() == 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

