/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint;

import am.ik.yavi.constraint.base.ContainerConstraintBase;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolatedValue;
import am.ik.yavi.core.ViolationMessage;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.ToIntFunction;

public class CollectionConstraint<T, L extends Collection<E>, E>
extends ContainerConstraintBase<T, L, CollectionConstraint<T, L, E>> {
    @Override
    public CollectionConstraint<T, L, E> cast() {
        return this;
    }

    public CollectionConstraint<T, L, E> contains(E s) {
        this.predicates().add(ConstraintPredicate.of(x -> x.contains(s), ViolationMessage.Default.COLLECTION_CONTAINS, () -> new Object[]{s}, NullAs.VALID));
        return this;
    }

    public CollectionConstraint<T, L, E> unique() {
        this.predicates().add(ConstraintPredicate.withViolatedValue(collection -> {
            LinkedHashSet duplicates = new LinkedHashSet();
            HashSet uniqElements = new HashSet(collection.size());
            for (Object element : collection) {
                if (uniqElements.contains(element)) {
                    duplicates.add(element);
                    continue;
                }
                uniqElements.add(element);
            }
            if (duplicates.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ViolatedValue(duplicates));
        }, ViolationMessage.Default.COLLECTION_UNIQUE, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CollectionConstraint<T, L, E> containsAll(Collection<? extends E> values) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(collection -> {
            HashSet missingValues = new HashSet(values);
            if (collection instanceof Set) {
                missingValues.removeAll((Collection<?>)collection);
            } else {
                missingValues.removeAll(new HashSet(collection));
            }
            return missingValues.isEmpty() ? Optional.empty() : Optional.of(new ViolatedValue(missingValues));
        }, ViolationMessage.Default.COLLECTION_CONTAINS_ALL, () -> new Object[]{values.toString()}, NullAs.VALID));
        return this;
    }

    @Override
    protected ToIntFunction<L> size() {
        return Collection::size;
    }
}

