/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint;

import am.ik.yavi.constraint.base.NumericConstraintBase;
import java.util.function.Predicate;

public class FloatConstraint<T>
extends NumericConstraintBase<T, Float, FloatConstraint<T>> {
    @Override
    public FloatConstraint<T> cast() {
        return this;
    }

    @Override
    protected Predicate<Float> isGreaterThan(Float min) {
        return x -> x.floatValue() > min.floatValue();
    }

    @Override
    protected Predicate<Float> isGreaterThanOrEqual(Float min) {
        return x -> x.floatValue() >= min.floatValue();
    }

    @Override
    protected Predicate<Float> isLessThan(Float max) {
        return x -> x.floatValue() < max.floatValue();
    }

    @Override
    protected Predicate<Float> isLessThanOrEqual(Float max) {
        return x -> x.floatValue() <= max.floatValue();
    }

    @Override
    protected Float zeroValue() {
        return Float.valueOf(0.0f);
    }
}

