/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.array;

import am.ik.yavi.constraint.base.ContainerConstraintBase;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.util.function.ToIntFunction;

public class ByteArrayConstraint<T>
extends ContainerConstraintBase<T, byte[], ByteArrayConstraint<T>> {
    @Override
    public ByteArrayConstraint<T> cast() {
        return this;
    }

    public ByteArrayConstraint<T> contains(byte v) {
        this.predicates().add(ConstraintPredicate.of(x -> {
            for (byte e : x) {
                if (e != v) continue;
                return true;
            }
            return false;
        }, ViolationMessage.Default.ARRAY_CONTAINS, () -> new Object[]{v}, NullAs.VALID));
        return this;
    }

    @Override
    protected ToIntFunction<byte[]> size() {
        return x -> ((byte[])x).length;
    }
}

