/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.array;

import am.ik.yavi.constraint.base.ContainerConstraintBase;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.util.function.ToIntFunction;

public class CharArrayConstraint<T>
extends ContainerConstraintBase<T, char[], CharArrayConstraint<T>> {
    @Override
    public CharArrayConstraint<T> cast() {
        return this;
    }

    public CharArrayConstraint<T> contains(char v) {
        this.predicates().add(ConstraintPredicate.of(x -> {
            for (char e : x) {
                if (e != v) continue;
                return true;
            }
            return false;
        }, ViolationMessage.Default.ARRAY_CONTAINS, () -> new Object[]{Character.valueOf(v)}, NullAs.VALID));
        return this;
    }

    @Override
    protected ToIntFunction<char[]> size() {
        return x -> ((char[])x).length;
    }
}

