/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.array;

import am.ik.yavi.constraint.base.ContainerConstraintBase;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.util.function.ToIntFunction;

public class FloatArrayConstraint<T>
extends ContainerConstraintBase<T, float[], FloatArrayConstraint<T>> {
    @Override
    public FloatArrayConstraint<T> cast() {
        return this;
    }

    public FloatArrayConstraint<T> contains(float v) {
        this.predicates().add(ConstraintPredicate.of(x -> {
            for (float e : x) {
                if (e != v) continue;
                return true;
            }
            return false;
        }, ViolationMessage.Default.ARRAY_CONTAINS, () -> new Object[]{Float.valueOf(v)}, NullAs.VALID));
        return this;
    }

    @Override
    protected ToIntFunction<float[]> size() {
        return x -> ((float[])x).length;
    }
}

