/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.array;

import am.ik.yavi.constraint.base.ContainerConstraintBase;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.util.function.ToIntFunction;

public class ShortArrayConstraint<T>
extends ContainerConstraintBase<T, short[], ShortArrayConstraint<T>> {
    @Override
    public ShortArrayConstraint<T> cast() {
        return this;
    }

    public ShortArrayConstraint<T> contains(short v) {
        this.predicates().add(ConstraintPredicate.of(x -> {
            for (short e : x) {
                if (e != v) continue;
                return true;
            }
            return false;
        }, ViolationMessage.Default.ARRAY_CONTAINS, () -> new Object[]{v}, NullAs.VALID));
        return this;
    }

    @Override
    protected ToIntFunction<short[]> size() {
        return x -> ((short[])x).length;
    }
}

