/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.base;

import am.ik.yavi.constraint.base.ConstraintBase;
import am.ik.yavi.core.Constraint;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolatedValue;
import am.ik.yavi.core.ViolationMessage;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;

public abstract class ContainerConstraintBase<T, V, C extends Constraint<T, V, C>>
extends ConstraintBase<T, V, C> {
    public C fixedSize(int size) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size().applyAsInt(x) == size, this.size()), ViolationMessage.Default.CONTAINER_FIXED_SIZE, () -> new Object[]{size}, NullAs.VALID));
        return this.cast();
    }

    public C greaterThan(int min) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size().applyAsInt(x) > min, this.size()), ViolationMessage.Default.CONTAINER_GREATER_THAN, () -> new Object[]{min}, NullAs.VALID));
        return this.cast();
    }

    public C greaterThanOrEqual(int min) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size().applyAsInt(x) >= min, this.size()), ViolationMessage.Default.CONTAINER_GREATER_THAN_OR_EQUAL, () -> new Object[]{min}, NullAs.VALID));
        return this.cast();
    }

    public C lessThan(int max) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size().applyAsInt(x) < max, this.size()), ViolationMessage.Default.CONTAINER_LESS_THAN, () -> new Object[]{max}, NullAs.VALID));
        return this.cast();
    }

    public C lessThanOrEqual(int max) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size().applyAsInt(x) <= max, this.size()), ViolationMessage.Default.CONTAINER_LESS_THAN_OR_EQUAL, () -> new Object[]{max}, NullAs.VALID));
        return this.cast();
    }

    public C notEmpty() {
        this.predicates().add(ConstraintPredicate.of(x -> x != null && this.size().applyAsInt(x) != 0, ViolationMessage.Default.CONTAINER_NOT_EMPTY, () -> new Object[0], NullAs.INVALID));
        return this.cast();
    }

    protected Function<V, Optional<ViolatedValue>> checkSizePredicate(Predicate<V> predicate, ToIntFunction<V> size) {
        return v -> {
            if (predicate.test(v)) {
                return Optional.empty();
            }
            int s = size.applyAsInt(v);
            return Optional.of(new ViolatedValue(s));
        };
    }

    protected abstract ToIntFunction<V> size();
}

