/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.base;

import am.ik.yavi.constraint.base.ConstraintBase;
import am.ik.yavi.core.Constraint;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.util.function.Predicate;

public abstract class NumericConstraintBase<T, V, C extends Constraint<T, V, C>>
extends ConstraintBase<T, V, C> {
    public C greaterThan(V min) {
        this.predicates().add(ConstraintPredicate.of(this.isGreaterThan(min), ViolationMessage.Default.NUMERIC_GREATER_THAN, () -> new Object[]{min}, NullAs.VALID));
        return this.cast();
    }

    public C greaterThanOrEqual(V min) {
        this.predicates().add(ConstraintPredicate.of(this.isGreaterThanOrEqual(min), ViolationMessage.Default.NUMERIC_GREATER_THAN_OR_EQUAL, () -> new Object[]{min}, NullAs.VALID));
        return this.cast();
    }

    public C lessThan(V max) {
        this.predicates().add(ConstraintPredicate.of(this.isLessThan(max), ViolationMessage.Default.NUMERIC_LESS_THAN, () -> new Object[]{max}, NullAs.VALID));
        return this.cast();
    }

    public C lessThanOrEqual(V max) {
        this.predicates().add(ConstraintPredicate.of(this.isLessThanOrEqual(max), ViolationMessage.Default.NUMERIC_LESS_THAN_OR_EQUAL, () -> new Object[]{max}, NullAs.VALID));
        return this.cast();
    }

    public C positive() {
        this.predicates().add(ConstraintPredicate.of(this.isGreaterThan(this.zeroValue()), ViolationMessage.Default.NUMERIC_POSITIVE, () -> new Object[0], NullAs.VALID));
        return this.cast();
    }

    public C positiveOrZero() {
        this.predicates().add(ConstraintPredicate.of(this.isGreaterThanOrEqual(this.zeroValue()), ViolationMessage.Default.NUMERIC_POSITIVE_OR_ZERO, () -> new Object[0], NullAs.VALID));
        return this.cast();
    }

    public C negative() {
        this.predicates().add(ConstraintPredicate.of(this.isLessThan(this.zeroValue()), ViolationMessage.Default.NUMERIC_NEGATIVE, () -> new Object[0], NullAs.VALID));
        return this.cast();
    }

    public C negativeOrZero() {
        this.predicates().add(ConstraintPredicate.of(this.isLessThanOrEqual(this.zeroValue()), ViolationMessage.Default.NUMERIC_NEGATIVE_OR_ZERO, () -> new Object[0], NullAs.VALID));
        return this.cast();
    }

    protected abstract Predicate<V> isGreaterThan(V var1);

    protected abstract Predicate<V> isGreaterThanOrEqual(V var1);

    protected abstract Predicate<V> isLessThan(V var1);

    protected abstract Predicate<V> isLessThanOrEqual(V var1);

    protected abstract V zeroValue();
}

