/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.base;

import am.ik.yavi.constraint.base.ConstraintBase;
import am.ik.yavi.core.Constraint;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.time.Clock;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongPredicate;
import java.util.function.Supplier;

public abstract class TemporalConstraintBase<T, V extends TemporalAccessor, C extends Constraint<T, V, C>>
extends ConstraintBase<T, V, C> {
    protected abstract boolean isAfter(V var1, V var2);

    protected abstract boolean isBefore(V var1, V var2);

    protected abstract V getNow(Clock var1);

    public C past() {
        return this.past(Clock.systemDefaultZone());
    }

    public C past(Clock clock) {
        return this.before(() -> this.getNow(clock), false).message(ViolationMessage.Default.TEMPORAL_PAST);
    }

    public C pastOrPresent() {
        return this.pastOrPresent(Clock.systemDefaultZone());
    }

    public C pastOrPresent(Clock clock) {
        return this.beforeOrEqual(() -> this.getNow(clock), false).message(ViolationMessage.Default.TEMPORAL_PAST_OR_PRESENT);
    }

    public C future() {
        return this.future(Clock.systemDefaultZone());
    }

    public C future(Clock clock) {
        return this.after(() -> this.getNow(clock), false).message(ViolationMessage.Default.TEMPORAL_FUTURE);
    }

    public C futureOrPresent() {
        return this.futureOrPresent(Clock.systemDefaultZone());
    }

    public C futureOrPresent(Clock clock) {
        return this.afterOrEqual(() -> this.getNow(clock), false).message(ViolationMessage.Default.TEMPORAL_FUTURE_OR_PRESENT);
    }

    public C before(Supplier<V> other, boolean memoize) {
        Supplier supplier = memoize ? TemporalConstraintBase.memoize(other) : other;
        this.predicates().add(ConstraintPredicate.of(x -> this.isBefore(x, (TemporalAccessor)supplier.get()), ViolationMessage.Default.TEMPORAL_BEFORE, () -> new Object[]{supplier.get()}, NullAs.VALID));
        return this.cast();
    }

    public C before(Supplier<V> other) {
        return this.before(other, true);
    }

    public C beforeOrEqual(Supplier<V> other, boolean memoize) {
        Supplier supplier = memoize ? TemporalConstraintBase.memoize(other) : other;
        this.predicates().add(ConstraintPredicate.of(x -> !this.isAfter(x, (TemporalAccessor)supplier.get()), ViolationMessage.Default.TEMPORAL_BEFORE_OR_EQUAL, () -> new Object[]{supplier.get()}, NullAs.VALID));
        return this.cast();
    }

    public C beforeOrEqual(Supplier<V> other) {
        return this.beforeOrEqual(other, true);
    }

    public C after(Supplier<V> other, boolean memoize) {
        Supplier supplier = memoize ? TemporalConstraintBase.memoize(other) : other;
        this.predicates().add(ConstraintPredicate.of(x -> this.isAfter(x, (TemporalAccessor)supplier.get()), ViolationMessage.Default.TEMPORAL_AFTER, () -> new Object[]{supplier.get()}, NullAs.VALID));
        return this.cast();
    }

    public C after(Supplier<V> other) {
        return this.after(other, true);
    }

    public C afterOrEqual(Supplier<V> other, boolean memoize) {
        Supplier supplier = memoize ? TemporalConstraintBase.memoize(other) : other;
        this.predicates().add(ConstraintPredicate.of(x -> !this.isBefore(x, (TemporalAccessor)supplier.get()), ViolationMessage.Default.TEMPORAL_AFTER_OR_EQUAL, () -> new Object[]{supplier.get()}, NullAs.VALID));
        return this.cast();
    }

    public C afterOrEqual(Supplier<V> other) {
        return this.afterOrEqual(other, true);
    }

    public C between(Supplier<V> rangeFrom, Supplier<V> rangeTo, boolean memoize) {
        Supplier supplierFrom = memoize ? TemporalConstraintBase.memoize(rangeFrom) : rangeFrom;
        Supplier supplierTo = memoize ? TemporalConstraintBase.memoize(rangeTo) : rangeTo;
        this.predicates().add(ConstraintPredicate.of(x -> {
            TemporalAccessor to;
            TemporalAccessor from = (TemporalAccessor)supplierFrom.get();
            if (this.isAfter(from, to = (TemporalAccessor)supplierTo.get())) {
                throw new IllegalArgumentException("Parameter 'rangeFrom' has to be before 'rangeTo'");
            }
            return this.isBefore(from, x) && this.isAfter(to, x);
        }, ViolationMessage.Default.TEMPORAL_BETWEEN, () -> new Object[]{supplierFrom.get(), supplierTo.get()}, NullAs.VALID));
        return this.cast();
    }

    public C between(Supplier<V> rangeFrom, Supplier<V> rangeTo) {
        return this.between(rangeFrom, rangeTo, true);
    }

    public C fieldPredicate(TemporalField field, LongPredicate predicate) {
        this.predicates().add(ConstraintPredicate.of(x -> predicate.test(x.getLong(field)), ViolationMessage.Default.TEMPORAL_FIELD, () -> new Object[]{field}, NullAs.VALID));
        return this.cast();
    }

    static <T> Supplier<T> memoize(Supplier<T> delegate) {
        AtomicReference supplier = new AtomicReference();
        return () -> {
            Object value = supplier.get();
            if (value == null) {
                return supplier.updateAndGet(arg_0 -> TemporalConstraintBase.lambda$null$16((Supplier)delegate, arg_0));
            }
            return value;
        };
    }

    private static /* synthetic */ Object lambda$null$16(Supplier delegate, Object prev) {
        return prev == null ? delegate.get() : prev;
    }
}

