/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.charsequence;

import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.nio.charset.Charset;

public class ByteSizeConstraint<T, E extends CharSequence>
extends CharSequenceConstraint<T, E> {
    private final Charset charset;

    public ByteSizeConstraint(CharSequenceConstraint<T, E> delegate, Charset charset) {
        this.charset = charset;
        this.predicates().addAll(delegate.predicates());
    }

    @Override
    public ByteSizeConstraint<T, E> cast() {
        return this;
    }

    @Override
    public ByteSizeConstraint<T, E> fixedSize(int size) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size(x) == size, this::size), ViolationMessage.Default.BYTE_SIZE_FIXED_SIZE, () -> new Object[]{size}, NullAs.VALID));
        return this;
    }

    @Override
    public ByteSizeConstraint<T, E> greaterThan(int min) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size(x) > min, this::size), ViolationMessage.Default.BYTE_SIZE_GREATER_THAN, () -> new Object[]{min}, NullAs.VALID));
        return this;
    }

    @Override
    public ByteSizeConstraint<T, E> greaterThanOrEqual(int min) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size(x) >= min, this::size), ViolationMessage.Default.BYTE_SIZE_GREATER_THAN_OR_EQUAL, () -> new Object[]{min}, NullAs.VALID));
        return this;
    }

    @Override
    public ByteSizeConstraint<T, E> lessThan(int max) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size(x) < max, this::size), ViolationMessage.Default.BYTE_SIZE_LESS_THAN, () -> new Object[]{max}, NullAs.VALID));
        return this;
    }

    @Override
    public ByteSizeConstraint<T, E> lessThanOrEqual(int max) {
        this.predicates().add(ConstraintPredicate.withViolatedValue(this.checkSizePredicate(x -> this.size(x) <= max, this::size), ViolationMessage.Default.BYTE_SIZE_LESS_THAN_OR_EQUAL, () -> new Object[]{max}, NullAs.VALID));
        return this;
    }

    private int size(E x) {
        return x.toString().getBytes(this.charset).length;
    }
}

