/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.charsequence;

import am.ik.yavi.jsr305.Nullable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@FunctionalInterface
public interface CodePoints<E extends CharSequence> {
    public Set<Integer> allExcludedCodePoints(E var1);

    public static interface Range {
        public static Range of(String begin, String end) {
            return Range.of(begin.codePoints().sorted().findFirst().orElse(0), end.codePoints().sorted().findFirst().orElse(0));
        }

        public static Range of(final int begin, final int end) {
            if (begin > end) {
                throw new IllegalArgumentException("begin must not be greater than end [" + begin + ", " + end + "]");
            }
            return new Range(){

                @Override
                public int begin() {
                    return begin;
                }

                @Override
                public int end() {
                    return end;
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof Range)) {
                        return false;
                    }
                    Range range = (Range)obj;
                    return Objects.equals(begin, range.begin()) && Objects.equals(end, range.end());
                }

                public int hashCode() {
                    return Objects.hash(begin, end);
                }
            };
        }

        public static Range single(int value) {
            return Range.of(value, value);
        }

        public int begin();

        public int end();
    }

    @FunctionalInterface
    public static interface CodePointsSet<E extends CharSequence>
    extends CodePoints<E> {
        @Override
        default public Set<Integer> allExcludedCodePoints(@Nullable E s) {
            Integer codePoint;
            if (s == null || s.length() == 0) {
                return Collections.emptySet();
            }
            String str = s.toString();
            LinkedHashSet<Integer> excludedCodePoints = new LinkedHashSet<Integer>();
            int len = str.length();
            Set<Integer> set = this.asSet();
            for (int i = 0; i < len; i += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(i);
                if (set.contains(codePoint)) continue;
                excludedCodePoints.add(codePoint);
            }
            return excludedCodePoints;
        }

        public Set<Integer> asSet();
    }

    @FunctionalInterface
    public static interface CodePointsRanges<E extends CharSequence>
    extends CodePoints<E> {
        @Override
        default public Set<Integer> allExcludedCodePoints(@Nullable E s) {
            Integer codePoint;
            if (s == null || s.length() == 0) {
                return Collections.emptySet();
            }
            String str = s.toString();
            LinkedHashSet<Integer> excludedCodePoints = new LinkedHashSet<Integer>();
            int len = str.length();
            List<Range> ranges = this.asRanges();
            for (int i = 0; i < len; i += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(i);
                boolean included = false;
                for (Range range : ranges) {
                    if (range.begin() > codePoint || codePoint > range.end()) continue;
                    included = true;
                    break;
                }
                if (included) continue;
                excludedCodePoints.add(codePoint);
            }
            return excludedCodePoints;
        }

        public List<Range> asRanges();
    }
}

