/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.charsequence;

import am.ik.yavi.constraint.CharSequenceConstraint;
import am.ik.yavi.constraint.charsequence.CodePoints;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolatedValue;
import am.ik.yavi.core.ViolationMessage;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class CodePointsConstraint<T, E extends CharSequence>
extends CharSequenceConstraint<T, E> {
    private final CodePoints<E> codePoints;

    public CodePointsConstraint(CharSequenceConstraint<T, E> delegate, CodePoints<E> codePoints) {
        this.codePoints = codePoints;
        this.predicates().addAll(delegate.predicates());
    }

    public CodePointsConstraint<T, E> asBlackList() {
        this.predicates().add(ConstraintPredicate.withViolatedValue(x -> {
            Integer codePoint;
            Set<Integer> excludedFromBlackList = this.codePoints.allExcludedCodePoints((CharSequence)x);
            String str = x.toString();
            int len = str.length();
            LinkedHashSet<Integer> included = new LinkedHashSet<Integer>();
            for (int i2 = 0; i2 < len; i2 += Character.charCount(codePoint)) {
                codePoint = str.codePointAt(i2);
                if (excludedFromBlackList.contains(codePoint)) continue;
                included.add(codePoint);
            }
            if (included.isEmpty()) {
                return Optional.empty();
            }
            List includedList = included.stream().map(i -> new String(new int[]{i}, 0, 1)).collect(Collectors.toList());
            return Optional.of(new ViolatedValue(includedList));
        }, ViolationMessage.Default.CODE_POINTS_NOT_INCLUDED, () -> new Object[0], NullAs.VALID));
        return this;
    }

    public CodePointsConstraint<T, E> asWhiteList() {
        this.predicates().add(ConstraintPredicate.withViolatedValue(x -> {
            Set<Integer> excludedFromWhiteList = this.codePoints.allExcludedCodePoints((CharSequence)x);
            if (excludedFromWhiteList.isEmpty()) {
                return Optional.empty();
            }
            List excludedList = excludedFromWhiteList.stream().map(i -> new String(new int[]{i}, 0, 1)).collect(Collectors.toList());
            return Optional.of(new ViolatedValue(excludedList));
        }, ViolationMessage.Default.CODE_POINTS_ALL_INCLUDED, () -> new Object[0], NullAs.VALID));
        return this;
    }

    @Override
    public CodePointsConstraint<T, E> cast() {
        return this;
    }

    public static class Builder<T, E extends CharSequence> {
        private final CodePoints<E> codePoints;
        private final CharSequenceConstraint<T, E> delegate;

        public Builder(CharSequenceConstraint<T, E> delegate, CodePoints<E> codePoints) {
            this.delegate = delegate;
            this.codePoints = codePoints;
        }

        public CodePointsConstraint<T, E> asBlackList() {
            return new CodePointsConstraint<T, E>(this.delegate, this.codePoints).asBlackList();
        }

        public CodePointsConstraint<T, E> asWhiteList() {
            return new CodePointsConstraint<T, E>(this.delegate, this.codePoints).asWhiteList();
        }
    }
}

