/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.charsequence.codepoints;

import am.ik.yavi.constraint.charsequence.CodePoints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class CompositeCodePoints<E extends CharSequence>
implements CodePoints<E> {
    private final List<CodePoints<E>> composite = new ArrayList<CodePoints<E>>();

    @SafeVarargs
    public CompositeCodePoints(CodePoints<E> ... codePoints) {
        LinkedHashSet<Integer> codePointsSet = new LinkedHashSet<Integer>();
        ArrayList<CodePoints.Range> ranges = new ArrayList<CodePoints.Range>();
        for (CodePoints<E> points : codePoints) {
            if (points instanceof CodePoints.CodePointsSet) {
                codePointsSet.addAll(((CodePoints.CodePointsSet)points).asSet());
                continue;
            }
            if (points instanceof CodePoints.CodePointsRanges) {
                ranges.addAll(((CodePoints.CodePointsRanges)points).asRanges());
                continue;
            }
            this.composite.add(points);
        }
        if (!codePointsSet.isEmpty()) {
            this.composite.add(() -> codePointsSet);
        }
        if (!ranges.isEmpty()) {
            this.composite.add(() -> ranges);
        }
        if (this.composite.isEmpty()) {
            throw new IllegalArgumentException("No code point is included");
        }
    }

    @Override
    public Set<Integer> allExcludedCodePoints(E s) {
        Set<Integer> excluded = null;
        for (CodePoints<E> codePoints : this.composite) {
            Set<Integer> e = codePoints.allExcludedCodePoints(s);
            if (e.isEmpty()) {
                return e;
            }
            if (excluded == null) {
                excluded = e;
                continue;
            }
            excluded.retainAll(e);
        }
        return excluded == null ? Collections.emptySet() : excluded;
    }
}

