/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.inetaddress;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;

public class InetAddressUtils {
    public static final String IPV4_REGEX = "^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$";
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(?:(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(?:25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$");
    private static final int MAX_BYTE = 128;
    private static final int MAX_UNSIGNED_SHORT = 65535;
    private static final int BASE_16 = 16;
    private static final int IPV6_MAX_HEX_GROUPS = 8;
    private static final int IPV6_MAX_HEX_DIGITS_PER_GROUP = 4;

    public static boolean isIpv4(String s) {
        return IPV4_PATTERN.matcher(s).matches();
    }

    public static boolean isIpv6(String s) {
        String[] partsZoneIdRemoved;
        String[] parts = s.split("/", -1);
        if (parts.length > 2) {
            return false;
        }
        if (parts.length == 2) {
            if (!parts[1].matches("\\d{1,3}")) {
                return false;
            }
            int bits = Integer.parseInt(parts[1]);
            if (bits < 0 || bits > 128) {
                return false;
            }
        }
        if ((partsZoneIdRemoved = parts[0].split("%", -1)).length > 2) {
            return false;
        }
        if (partsZoneIdRemoved.length == 2 && !partsZoneIdRemoved[1].matches("[^\\s/%]+")) {
            return false;
        }
        String firstPart = partsZoneIdRemoved[0];
        boolean containsCompressedZeroes = firstPart.contains("::");
        if (containsCompressedZeroes && firstPart.indexOf("::") != firstPart.lastIndexOf("::")) {
            return false;
        }
        if (firstPart.startsWith(":") && !firstPart.startsWith("::") || firstPart.endsWith(":") && !firstPart.endsWith("::")) {
            return false;
        }
        String[] octets = firstPart.split(":");
        if (containsCompressedZeroes) {
            ArrayList<String> octetList = new ArrayList<String>(Arrays.asList(octets));
            if (firstPart.endsWith("::")) {
                octetList.add("");
            } else if (firstPart.startsWith("::") && !octetList.isEmpty()) {
                octetList.remove(0);
            }
            octets = octetList.toArray(new String[0]);
        }
        if (octets.length > 8) {
            return false;
        }
        int validOctets = 0;
        int emptyOctets = 0;
        for (int index = 0; index < octets.length; ++index) {
            String octet = octets[index];
            if (octet.isEmpty()) {
                if (++emptyOctets > 1) {
                    return false;
                }
            } else {
                emptyOctets = 0;
                if (index == octets.length - 1 && octet.contains(".")) {
                    if (!InetAddressUtils.isIpv4(octet)) {
                        return false;
                    }
                    validOctets += 2;
                    continue;
                }
                if (octet.length() > 4) {
                    return false;
                }
                int octetInt = 0;
                try {
                    octetInt = Integer.parseInt(octet, 16);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                if (octetInt < 0 || octetInt > 65535) {
                    return false;
                }
            }
            ++validOctets;
        }
        return validOctets <= 8 && (validOctets >= 8 || containsCompressedZeroes);
    }
}

