/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.password;

import am.ik.yavi.constraint.password.PasswordPolicy;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolationMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public abstract class PasswordPoliciesBuilder<T, E, B extends PasswordPoliciesBuilder<T, E, B>> {
    private final Set<PasswordPolicy<E>> requiredPolicies = new LinkedHashSet<PasswordPolicy<E>>();
    private final Set<PasswordPolicy<E>> optionalPolicies = new LinkedHashSet<PasswordPolicy<E>>();
    private int minimumOptionalPoliciesRequirement;

    protected abstract B cast();

    public B required(PasswordPolicy<E> policy) {
        this.requiredPolicies.add(policy);
        return this.cast();
    }

    @SafeVarargs
    public final B required(PasswordPolicy<E> ... policies) {
        this.requiredPolicies.addAll(Arrays.asList(policies));
        return this.cast();
    }

    @SafeVarargs
    public final B optional(int minimumRequirement, PasswordPolicy<E> ... policies) {
        this.optionalPolicies.addAll(Arrays.asList(policies));
        this.minimumOptionalPoliciesRequirement = minimumRequirement;
        return this.cast();
    }

    public List<ConstraintPredicate<E>> build() {
        ArrayList<ConstraintPredicate<ConstraintPredicate<E>>> predicates = new ArrayList<ConstraintPredicate<ConstraintPredicate<E>>>();
        if (!this.requiredPolicies.isEmpty()) {
            predicates.addAll(this.requiredConstraintPredicates());
        }
        if (!this.optionalPolicies.isEmpty()) {
            predicates.add(this.optionalConstraintPredicate());
        }
        return predicates;
    }

    private List<ConstraintPredicate<E>> requiredConstraintPredicates() {
        return this.requiredPolicies.stream().map(policy -> ConstraintPredicate.of(policy, ViolationMessage.Default.PASSWORD_REQUIRED, () -> new Object[]{policy.name()}, NullAs.VALID)).collect(Collectors.toList());
    }

    private ConstraintPredicate<E> optionalConstraintPredicate() {
        Predicate<Object> predicate = input -> {
            int matched = 0;
            for (PasswordPolicy<E> policy : this.optionalPolicies) {
                if (!policy.test(input)) continue;
                ++matched;
            }
            return matched >= this.minimumOptionalPoliciesRequirement;
        };
        return ConstraintPredicate.of(predicate, ViolationMessage.Default.PASSWORD_OPTIONAL, () -> new Object[]{this.minimumOptionalPoliciesRequirement, this.optionalPolicies.stream().map(PasswordPolicy::name).collect(Collectors.toList())}, NullAs.VALID);
    }
}

