/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.constraint.password;

import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface PasswordPolicy<T>
extends Predicate<T> {
    public static final PatternPasswordPolicy<String> UPPERCASE = PasswordPolicy.pattern("Uppercase", "[A-Z]");
    public static final PatternPasswordPolicy<String> LOWERCASE = PasswordPolicy.pattern("Lowercase", "[a-z]");
    public static final PatternPasswordPolicy<String> ALPHABETS = PasswordPolicy.pattern("Alphabets", "[a-zA-Z]");
    public static final PatternPasswordPolicy<String> NUMBERS = PasswordPolicy.pattern("Numbers", "[0-9]");
    public static final PatternPasswordPolicy<String> SYMBOLS = PasswordPolicy.pattern("Symbols", "[!-/:-@\\[-`{-\\~]");

    default public String name() {
        return this.getClass().getSimpleName().replace(PasswordPolicy.class.getSimpleName(), "");
    }

    default public PasswordPolicy<T> name(final String name) {
        return new PasswordPolicy<T>(){

            @Override
            public String name() {
                return name;
            }

            @Override
            public boolean test(T t) {
                return PasswordPolicy.this.test(t);
            }
        };
    }

    public static <T> PasswordPolicy<T> of(final String name, final Predicate<T> predicate) {
        return new PasswordPolicy<T>(){

            @Override
            public boolean test(T t) {
                return predicate.test(t);
            }

            @Override
            public String name() {
                return name;
            }
        };
    }

    public static <T extends CharSequence> PatternPasswordPolicy<T> pattern(String name, String regex) {
        return new PatternPasswordPolicy(name, regex);
    }

    public static class PatternPasswordPolicy<T extends CharSequence>
    implements PasswordPolicy<T> {
        private final String name;
        private final String regex;
        private final Pattern pattern;
        private final int count;

        public PatternPasswordPolicy(String name, String regex) {
            this(name, regex, 1);
        }

        public PatternPasswordPolicy(String name, String regex, int count) {
            if (count <= 0) {
                throw new IllegalArgumentException("'count' must be greater than 0");
            }
            this.name = name;
            this.regex = regex;
            this.pattern = Pattern.compile(regex);
            this.count = count;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public boolean test(T input) {
            Matcher matcher = this.pattern.matcher((CharSequence)input);
            int count = 0;
            while (matcher.find()) {
                if (++count < this.count) continue;
                return true;
            }
            return false;
        }

        public PatternPasswordPolicy<T> count(int count) {
            if (this.count == count) {
                return this;
            }
            return new PatternPasswordPolicy<T>(this.name, this.regex, count);
        }
    }
}

