/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.CustomConstraint;
import am.ik.yavi.core.NullAs;
import am.ik.yavi.core.ViolatedArguments;
import am.ik.yavi.core.ViolationMessage;
import am.ik.yavi.jsr305.Nullable;
import java.util.Collection;
import java.util.Deque;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Constraint<T, V, C extends Constraint<T, V, C>> {
    public C cast();

    default public C isNull() {
        this.predicates().add(ConstraintPredicate.of(Objects::isNull, ViolationMessage.Default.OBJECT_IS_NULL, () -> new Object[0], NullAs.INVALID));
        return this.cast();
    }

    default public C equalTo(@Nullable V other) {
        this.predicates().add(ConstraintPredicate.of(Predicate.isEqual(other), ViolationMessage.Default.OBJECT_EQUAL_TO, () -> new Object[]{other}, NullAs.VALID));
        return this.cast();
    }

    default public C oneOf(Collection<V> values) {
        this.predicates().add(ConstraintPredicate.of(values::contains, ViolationMessage.Default.OBJECT_ONE_OF, () -> new Object[]{values}, NullAs.VALID));
        return this.cast();
    }

    default public C notOneOf(Collection<V> values) {
        Predicate<Object> notOneOf = v -> !values.contains(v);
        this.predicates().add(ConstraintPredicate.of(notOneOf, ViolationMessage.Default.OBJECT_NOT_ONE_OF, () -> new Object[]{values}, NullAs.VALID));
        return this.cast();
    }

    default public C message(String message) {
        ConstraintPredicate<V> predicate = this.predicates().pollLast();
        if (predicate == null) {
            throw new IllegalStateException("no constraint found to override!");
        }
        this.predicates().addLast(predicate.overrideMessage(message));
        return this.cast();
    }

    default public C message(ViolationMessage message) {
        ConstraintPredicate<V> predicate = this.predicates().pollLast();
        if (predicate == null) {
            throw new IllegalStateException("no constraint found to override!");
        }
        this.predicates().addLast(predicate.overrideMessage(message));
        return this.cast();
    }

    default public C notNull() {
        this.predicates().add(ConstraintPredicate.of(Objects::nonNull, ViolationMessage.Default.OBJECT_NOT_NULL, () -> new Object[0], NullAs.INVALID));
        return this.cast();
    }

    default public C predicate(Predicate<V> predicate, ViolationMessage violationMessage) {
        Supplier<Object[]> arguments = ViolatedArguments.supplyArguments(predicate);
        this.predicates().add(ConstraintPredicate.of(predicate, violationMessage, arguments, NullAs.VALID));
        return this.cast();
    }

    default public C predicate(Predicate<V> predicate, String messageKey, String defaultMessageFormat) {
        return this.predicate(predicate, ViolationMessage.of(messageKey, defaultMessageFormat));
    }

    default public C predicate(CustomConstraint<V> constraint) {
        return this.predicate(constraint, constraint);
    }

    default public C predicateNullable(Predicate<V> predicate, ViolationMessage violationMessage) {
        Supplier<Object[]> arguments = ViolatedArguments.supplyArguments(predicate);
        this.predicates().add(ConstraintPredicate.of(predicate, violationMessage, arguments, NullAs.INVALID));
        return this.cast();
    }

    default public C predicateNullable(Predicate<V> predicate, String messageKey, String defaultMessageFormat) {
        return this.predicateNullable(predicate, ViolationMessage.of(messageKey, defaultMessageFormat));
    }

    default public C predicateNullable(CustomConstraint<V> constraint) {
        return this.predicateNullable(constraint, constraint);
    }

    public Deque<ConstraintPredicate<V>> predicates();
}

