/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.jsr305.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public interface ConstraintContext {
    public Attribute attribute(String var1);

    public String name();

    public static ConstraintContext from(final Map<String, ?> map) {
        return new ConstraintContext(){

            @Override
            public Attribute attribute(String key) {
                return () -> map.get(key);
            }

            @Override
            public String name() {
                return "ConstraintContextFromMap";
            }
        };
    }

    public static ConstraintContext from(final Function<String, ?> function) {
        return new ConstraintContext(){

            @Override
            public Attribute attribute(String key) {
                return () -> function.apply(key);
            }

            @Override
            public String name() {
                return "ConstraintContextFromFunction";
            }
        };
    }

    @FunctionalInterface
    public static interface Attribute {
        @Nullable
        public Object value();

        @Nullable
        default public <T> T value(Class<T> clazz) {
            return clazz.cast(this.value());
        }

        default public boolean exists() {
            return this.value() != null;
        }

        default public boolean isEqualTo(Object value) {
            return Objects.equals(this.value(), value);
        }
    }
}

