/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ViolatedValue;
import am.ik.yavi.core.ViolationDetail;
import am.ik.yavi.jsr305.Nullable;
import am.ik.yavi.message.MessageFormatter;
import am.ik.yavi.message.SimpleMessageFormatter;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;

public class ConstraintViolation {
    private final Object[] args;
    private final String defaultMessageFormat;
    private final Locale locale;
    private final MessageFormatter messageFormatter;
    private final String messageKey;
    private final String name;

    @Deprecated
    public ConstraintViolation(String name, String messageKey, String defaultMessageFormat, @Nullable Object[] args, @Nullable MessageFormatter messageFormatter, @Nullable Locale locale) {
        this.name = name;
        this.messageKey = messageKey;
        this.defaultMessageFormat = defaultMessageFormat;
        this.args = args == null ? new Object[]{} : args;
        this.messageFormatter = messageFormatter == null ? SimpleMessageFormatter.getInstance() : messageFormatter;
        this.locale = locale == null ? Locale.getDefault() : locale;
    }

    public Object[] args() {
        return this.args;
    }

    public String defaultMessageFormat() {
        return this.defaultMessageFormat;
    }

    public ViolationDetail detail() {
        return new ViolationDetail(this.messageKey, this.args, this.message());
    }

    public ViolationDetail detail(MessageFormatter messageFormatter) {
        return new ViolationDetail(this.messageKey, this.args, this.message(messageFormatter));
    }

    public Locale locale() {
        return this.locale;
    }

    public String message() {
        return this.messageFormatter.format(this.messageKey, this.defaultMessageFormat, this.args, this.locale);
    }

    public String message(MessageFormatter messageFormatter) {
        return messageFormatter.format(this.messageKey, this.defaultMessageFormat, this.args, this.locale);
    }

    public String messageKey() {
        return this.messageKey;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return "ConstraintViolation{name='" + this.name + '\'' + ", messageKey='" + this.messageKey + '\'' + ", defaultMessageFormat='" + this.defaultMessageFormat + '\'' + ", args=" + Arrays.toString(this.args) + '}';
    }

    public Object violatedValue() {
        return this.args[this.args.length - 1];
    }

    public ConstraintViolation rename(Function<? super String, String> rename) {
        String newName = rename.apply(this.name);
        Object[] newArgs = (Object[])this.args().clone();
        if (newArgs.length > 0) {
            newArgs[0] = newName;
        }
        return new ConstraintViolation(newName, this.messageKey, this.defaultMessageFormat, newArgs, this.messageFormatter, this.locale);
    }

    public ConstraintViolation indexed(int index) {
        return this.rename(name -> name + "[" + index + "]");
    }

    public static StagedBuilders.Name builder() {
        return new Builder();
    }

    public static interface StagedBuilders {

        public static interface Optionals {
            public Optionals args(Object ... var1);

            public Optionals argsWithPrependedName(Object ... var1);

            public Optionals argsWithPrependedNameAndAppendedViolatedValue(Object[] var1, ViolatedValue var2);

            public Optionals messageFormatter(MessageFormatter var1);

            public Optionals locale(Locale var1);

            public ConstraintViolation build();
        }

        public static interface DefaultMessageFormat {
            public Optionals defaultMessageFormat(String var1);
        }

        public static interface MessageKey {
            public static final String DEFAULT_MESSAGE_KEY = "_";

            public DefaultMessageFormat messageKey(String var1);

            default public ConstraintViolation message(String message) {
                return this.messageKey(DEFAULT_MESSAGE_KEY).defaultMessageFormat(message).argsWithPrependedName(new Object[0]).build();
            }
        }

        public static interface Name {
            public MessageKey name(String var1);
        }
    }

    public static class Builder
    implements StagedBuilders.Name,
    StagedBuilders.MessageKey,
    StagedBuilders.DefaultMessageFormat,
    StagedBuilders.Optionals {
        private String name;
        private String messageKey;
        private String defaultMessageFormat;
        private Object[] args;
        private MessageFormatter messageFormatter;
        private Locale locale;

        private Builder() {
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder messageKey(String messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        @Override
        public Builder defaultMessageFormat(String defaultMessageFormat) {
            this.defaultMessageFormat = defaultMessageFormat;
            return this;
        }

        @Override
        public Builder args(Object ... args) {
            this.args = args;
            return this;
        }

        @Override
        public Builder argsWithPrependedName(Object ... args) {
            Object[] argsWithName = new Object[args.length + 1];
            argsWithName[0] = this.name;
            System.arraycopy(args, 0, argsWithName, 1, args.length);
            this.args = argsWithName;
            return this;
        }

        @Override
        public Builder argsWithPrependedNameAndAppendedViolatedValue(Object[] args, ViolatedValue violatedValue) {
            Object[] completeArgs = new Object[args.length + 2];
            completeArgs[0] = this.name;
            System.arraycopy(args, 0, completeArgs, 1, args.length);
            completeArgs[args.length + 1] = violatedValue.value();
            this.args = completeArgs;
            return this;
        }

        @Override
        public Builder messageFormatter(MessageFormatter messageFormatter) {
            this.messageFormatter = messageFormatter;
            return this;
        }

        @Override
        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        @Override
        public ConstraintViolation build() {
            return new ConstraintViolation(this.name, this.messageKey, this.defaultMessageFormat, this.args, this.messageFormatter, this.locale);
        }
    }
}

