/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ConstraintViolation;
import am.ik.yavi.core.ViolationDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ConstraintViolations
implements List<ConstraintViolation> {
    private final List<ConstraintViolation> delegate;

    public static ConstraintViolations of(List<ConstraintViolation> delegate) {
        if (delegate instanceof ConstraintViolations) {
            return (ConstraintViolations)delegate;
        }
        return new ConstraintViolations(delegate);
    }

    public ConstraintViolations() {
        this.delegate = new ArrayList<ConstraintViolation>();
    }

    public ConstraintViolations(List<ConstraintViolation> delegate) {
        this.delegate = delegate;
    }

    @Override
    public final boolean add(ConstraintViolation constraintViolation) {
        return this.delegate.add(constraintViolation);
    }

    @Override
    public final void add(int index, ConstraintViolation element) {
        this.delegate.add(index, element);
    }

    @Override
    public final boolean addAll(Collection<? extends ConstraintViolation> c) {
        return this.delegate.addAll(c);
    }

    @Override
    public final boolean addAll(int index, Collection<? extends ConstraintViolation> c) {
        return this.delegate.addAll(c);
    }

    public ConstraintViolations apply(Callback callback) {
        this.forEach(v -> callback.apply(v.name(), v.messageKey(), v.args(), v.message()));
        return this;
    }

    @Override
    public final void clear() {
        this.delegate.clear();
    }

    @Override
    public final boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public final boolean containsAll(Collection<?> c) {
        return this.delegate.containsAll(c);
    }

    public List<ViolationDetail> details() {
        return this.delegate.stream().map(ConstraintViolation::detail).collect(Collectors.toList());
    }

    @Override
    public final ConstraintViolation get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public final int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public final boolean isValid() {
        return this.delegate.isEmpty();
    }

    @Override
    public final Iterator<ConstraintViolation> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public final int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public final ListIterator<ConstraintViolation> listIterator() {
        return this.delegate.listIterator();
    }

    @Override
    public final ListIterator<ConstraintViolation> listIterator(int index) {
        return this.delegate.listIterator(index);
    }

    @Override
    public final boolean remove(Object o) {
        return this.delegate.remove(o);
    }

    @Override
    public final ConstraintViolation remove(int index) {
        return this.delegate.remove(index);
    }

    @Override
    public final boolean removeAll(Collection<?> c) {
        return this.delegate.removeAll(c);
    }

    @Override
    public final boolean retainAll(Collection<?> c) {
        return this.delegate.retainAll(c);
    }

    @Override
    public final ConstraintViolation set(int index, ConstraintViolation element) {
        return this.delegate.set(index, element);
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    @Override
    public final List<ConstraintViolation> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public final <E extends RuntimeException> void throwIfInvalid(Function<ConstraintViolations, E> toException) throws E {
        if (!this.isValid()) {
            throw (RuntimeException)toException.apply(this);
        }
    }

    @Override
    public final Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public final <T> T[] toArray(T[] a) {
        return this.delegate.toArray(a);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public final List<ConstraintViolation> violations() {
        return Collections.unmodifiableList(this.delegate);
    }

    @FunctionalInterface
    public static interface Callback {
        public void apply(String var1, String var2, Object[] var3, String var4);
    }
}

