/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ConstraintContext;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.Validatable;
import am.ik.yavi.core.Validator;
import java.util.Locale;
import java.util.function.Function;

public class NestedValidator<T, N>
implements Validatable<T> {
    private final Function<T, N> nested;
    private final Validatable<N> validator;
    private final String prefix;

    public NestedValidator(Function<T, N> nested, Validatable<N> validator, String prefix) {
        this.nested = nested;
        this.prefix = prefix;
        this.validator = this.prefixedValidatorIfNeeded(validator, prefix);
    }

    private Validatable<N> prefixedValidatorIfNeeded(Validatable<N> validator, String prefix) {
        if (validator instanceof NestedValidator) {
            NestedValidator nestedValidator = (NestedValidator)validator;
            return new NestedValidator<T, N>(nestedValidator.nested, nestedValidator.validator, prefix);
        }
        return validator instanceof Validator ? ((Validator)validator).prefixed(prefix) : validator;
    }

    @Override
    public ConstraintViolations validate(T target, Locale locale, ConstraintContext constraintContext) {
        N n = this.nested.apply(target);
        if (n != null) {
            return this.validator.validate(n, locale, constraintContext);
        }
        return new ConstraintViolations();
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public Validatable<T> failFast(boolean failFast) {
        Validatable<N> validatable = this.validator.failFast(failFast);
        return new NestedValidator<T, N>(this.nested, validatable, this.prefix);
    }

    @Override
    public boolean isFailFast() {
        return this.validator.isFailFast();
    }
}

