/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ApplicativeValidator;
import am.ik.yavi.core.ConstraintContext;
import am.ik.yavi.core.ConstraintGroup;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.ErrorHandler;
import am.ik.yavi.core.Validated;
import am.ik.yavi.core.ValueValidator;
import am.ik.yavi.fn.Validation;
import java.util.Locale;
import java.util.function.BiConsumer;

@FunctionalInterface
public interface Validatable<T> {
    public ConstraintViolations validate(T var1, Locale var2, ConstraintContext var3);

    default public ConstraintViolations validate(T target) {
        return this.validate(target, Locale.getDefault(), ConstraintGroup.DEFAULT);
    }

    default public ConstraintViolations validate(T target, Locale locale) {
        return this.validate(target, locale, ConstraintGroup.DEFAULT);
    }

    default public ConstraintViolations validate(T target, ConstraintContext constraintContext) {
        return this.validate(target, Locale.getDefault(), constraintContext);
    }

    default public ApplicativeValidator<T> applicative() {
        return (target, locale, constraintContext) -> {
            ConstraintViolations violations = this.validate(target, locale, constraintContext);
            if (violations.isValid()) {
                return Validated.of(Validation.success(target));
            }
            return Validated.of(Validation.failure(violations));
        };
    }

    public static <A1, R> Validatable<A1> from(ValueValidator<? super A1, ? extends R> applicative) {
        return (target, locale, constraintGroup) -> applicative.validate((Object)target, locale, constraintGroup).fold(ConstraintViolations::of, result -> new ConstraintViolations());
    }

    default public <E> BiConsumer<T, E> toBiConsumer(ErrorHandler<E> errorHandler) {
        return (target, errors) -> {
            ConstraintViolations violations = this.validate(target);
            if (!violations.isValid()) {
                violations.apply((name, messageKey, args, defaultMessage) -> errorHandler.handleError(errors, name, messageKey, args, defaultMessage));
            }
        };
    }

    default public Validatable<T> failFast(boolean failFast) {
        throw new UnsupportedOperationException("failFast is not implemented!");
    }

    default public boolean isFailFast() {
        return false;
    }
}

