/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ConstraintViolation;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.fn.Validation;
import am.ik.yavi.fn.Validations;
import am.ik.yavi.jsr305.Nullable;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Validated<T>
extends Validation<ConstraintViolation, T> {
    private final Validation<ConstraintViolation, ? extends T> delegate;

    public static <T> Validated<T> of(Validation<ConstraintViolation, ? extends T> delegate) {
        if (delegate instanceof Validated) {
            return (Validated)delegate;
        }
        return new Validated<T>(delegate);
    }

    public static <T> Validated<T> successWith(@Nullable T value) {
        return new Validated<T>(Validation.success(value));
    }

    public static <T> Validated<T> failureWith(List<ConstraintViolation> errors) {
        return new Validated(Validation.failure(errors));
    }

    public static <T> Validated<T> failureWith(ConstraintViolation ... errors) {
        return new Validated(Validation.failure(errors));
    }

    Validated(Validation<ConstraintViolation, ? extends T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean isValid() {
        return this.delegate.isValid();
    }

    @Override
    public T value() {
        return this.delegate.value();
    }

    @Override
    public T valueNullable() {
        return this.delegate.valueNullable();
    }

    public ConstraintViolations errors() {
        return ConstraintViolations.of(this.delegate.errors());
    }

    @Override
    protected <U, V extends Validation<ConstraintViolation, U>> V yieldSuccess(@Nullable U value) {
        return (V)Validated.of(Validation.success(value));
    }

    @Override
    protected <U, V extends Validation<ConstraintViolation, U>> V yieldFailure(List<ConstraintViolation> errors) {
        return (V)Validated.of(Validation.failure(errors));
    }

    public Validated<T> peek(Consumer<? super T> consumer) {
        return Validated.of(super.peek(consumer));
    }

    public Validated<T> peekErrors(Consumer<? super List<ConstraintViolation>> consumer) {
        return Validated.of(super.peekErrors(consumer));
    }

    public Validated<T> indexed(int index) {
        return Validated.of(this.mapError(violation -> violation.indexed(index)));
    }

    public static <T> Validated<List<T>> sequence(Iterable<Validated<? extends T>> values) {
        return Validated.of(Validations.sequence(values));
    }

    public static <T, U> Validated<List<U>> traverse(Iterable<T> values, Function<? super T, Validated<? extends U>> mapper) {
        return Validated.of(Validations.traverse(values, mapper));
    }

    public static <T, U> Validated<List<U>> traverseIndexed(Iterable<T> values, Validations.IndexedTraverser<? super T, Validated<? extends U>> mapper) {
        return Validated.of(Validations.traverseIndexed(values, mapper));
    }

    public static <T, U, C extends Collection<U>> Validated<C> traverseIndexed(Iterable<T> values, Validations.IndexedTraverser<? super T, Validated<? extends U>> mapper, Supplier<C> factory) {
        return Validated.of(Validations.traverseIndexed(values, mapper, factory));
    }

    public static <T, U> Validated<Optional<U>> traverseOptional(Optional<T> value, Function<? super T, ? extends Validated<? extends U>> mapper) {
        return Validated.of(Validations.traverseOptional(value, mapper));
    }
}

