/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ApplicativeValidator;
import am.ik.yavi.core.CollectionValidator;
import am.ik.yavi.core.ConstraintCondition;
import am.ik.yavi.core.ConstraintContext;
import am.ik.yavi.core.ConstraintPredicate;
import am.ik.yavi.core.ConstraintPredicates;
import am.ik.yavi.core.ConstraintViolation;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.NestedConstraintPredicates;
import am.ik.yavi.core.Validatable;
import am.ik.yavi.core.ViolatedArguments;
import am.ik.yavi.core.ViolatedValue;
import am.ik.yavi.core.ViolationMessage;
import am.ik.yavi.fn.Pair;
import am.ik.yavi.message.MessageFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class Validator<T>
implements Validatable<T> {
    private final List<CollectionValidator<T, ?, ?>> collectionValidators;
    private final List<Pair<ConstraintCondition<T>, Validatable<T>>> conditionalValidators;
    private final MessageFormatter messageFormatter;
    private final String messageKeySeparator;
    private final List<ConstraintPredicates<T, ?>> predicatesList;
    private final String prefix;
    private final boolean failFast;
    private final ApplicativeValidator<T> applicativeValidator = Validatable.super.applicative();

    public Validator(String messageKeySeparator, List<ConstraintPredicates<T, ?>> predicatesList, List<CollectionValidator<T, ?, ?>> collectionValidators, List<Pair<ConstraintCondition<T>, Validatable<T>>> conditionalValidators, MessageFormatter messageFormatter) {
        this(messageKeySeparator, predicatesList, collectionValidators, conditionalValidators, messageFormatter, false);
    }

    public Validator(String messageKeySeparator, List<ConstraintPredicates<T, ?>> predicatesList, List<CollectionValidator<T, ?, ?>> collectionValidators, List<Pair<ConstraintCondition<T>, Validatable<T>>> conditionalValidators, MessageFormatter messageFormatter, boolean failFast) {
        this(messageKeySeparator, predicatesList, collectionValidators, conditionalValidators, messageFormatter, failFast, "");
    }

    private Validator(String messageKeySeparator, List<ConstraintPredicates<T, ?>> predicatesList, List<CollectionValidator<T, ?, ?>> collectionValidators, List<Pair<ConstraintCondition<T>, Validatable<T>>> conditionalValidators, MessageFormatter messageFormatter, boolean failFast, String prefix) {
        this.messageKeySeparator = messageKeySeparator;
        this.predicatesList = Collections.unmodifiableList(predicatesList);
        this.collectionValidators = Collections.unmodifiableList(collectionValidators);
        this.conditionalValidators = Collections.unmodifiableList(conditionalValidators);
        this.messageFormatter = messageFormatter;
        this.failFast = failFast;
        this.prefix = prefix == null || prefix.isEmpty() || prefix.endsWith(this.messageKeySeparator) ? prefix : prefix + this.messageKeySeparator;
    }

    public Validator<T> prefixed(String prefix) {
        return new Validator<T>(this.messageKeySeparator, this.predicatesList, this.collectionValidators, this.conditionalValidators, this.messageFormatter, this.failFast, prefix);
    }

    @Override
    public Validator<T> failFast(boolean failFast) {
        return new Validator<T>(this.messageKeySeparator, this.predicatesList, this.collectionValidators, this.conditionalValidators, this.messageFormatter, failFast, this.prefix);
    }

    @Override
    public boolean isFailFast() {
        return this.failFast;
    }

    public void forEachPredicates(Consumer<ConstraintPredicates<T, ?>> action) {
        this.predicatesList.forEach(action);
    }

    public void forEachCollectionValidator(Consumer<CollectionValidator<T, ?, ?>> action) {
        this.collectionValidators.forEach(action);
    }

    public void forEachConditionalValidator(Consumer<Pair<ConstraintCondition<T>, Validatable<T>>> action) {
        this.conditionalValidators.forEach(action);
    }

    @Override
    public ConstraintViolations validate(T target, Locale locale, ConstraintContext constraintContext) {
        return this.validate(target, "", -1, locale, constraintContext);
    }

    @Override
    public ApplicativeValidator<T> applicative() {
        return this.applicativeValidator;
    }

    private String indexedName(String name, String collectionName, int index) {
        if (index < 0) {
            return name;
        }
        if (name.isEmpty()) {
            return collectionName + "[" + index + "]";
        }
        return collectionName + "[" + index + "]" + this.messageKeySeparator + name;
    }

    private ConstraintViolations validate(T target, String collectionName, int index, Locale locale, ConstraintContext constraintContext) {
        Validatable<Object> validator;
        if (target == null) {
            throw new IllegalArgumentException("target must not be null");
        }
        ConstraintViolations violations = new ConstraintViolations();
        for (ConstraintPredicates<T, ?> constraintPredicates : this.predicatesList) {
            Object nested;
            Object nestedValue;
            if (constraintPredicates instanceof NestedConstraintPredicates && (nestedValue = ((NestedConstraintPredicates)(nested = (NestedConstraintPredicates)constraintPredicates)).nestedValue(target)) == null) continue;
            nested = constraintPredicates.predicates().iterator();
            while (nested.hasNext()) {
                Optional<ViolatedValue> violated;
                ConstraintPredicate constraintPredicate = (ConstraintPredicate)nested.next();
                Object v = constraintPredicates.toValue().apply(target);
                if (v == null && constraintPredicate.nullValidity().skipNull() || !(violated = constraintPredicate.violatedValue(v)).isPresent()) continue;
                ViolatedValue violatedValue = violated.get();
                String name2 = this.prefix + this.indexedName(constraintPredicates.name(), collectionName, index);
                Supplier<Object[]> argsSupplier = constraintPredicate.args();
                Object[] args = argsSupplier instanceof ViolatedArguments ? ((ViolatedArguments)argsSupplier).arguments(violatedValue.value()) : argsSupplier.get();
                ConstraintViolation violation = ConstraintViolation.builder().name(name2).messageKey(constraintPredicate.messageKey()).defaultMessageFormat(constraintPredicate.defaultMessageFormat()).argsWithPrependedNameAndAppendedViolatedValue(args, violatedValue).messageFormatter(this.messageFormatter).locale(locale).build();
                violations.add(violation);
                if (!this.failFast && (!(constraintPredicates instanceof NestedConstraintPredicates) || !((NestedConstraintPredicates)constraintPredicates).isFailFast())) continue;
                return violations;
            }
        }
        for (CollectionValidator collectionValidator : this.collectionValidators) {
            Collection collection = (Collection)collectionValidator.toCollection().apply(target);
            if (collection == null) continue;
            validator = this.failFast ? collectionValidator.validator().failFast(true) : collectionValidator.validator();
            int i = 0;
            for (Object element : collection) {
                String nestedName = this.indexedName(collectionValidator.name(), collectionName, index);
                if (element != null) {
                    ConstraintViolations v = super.validate(element, nestedName, i++, locale, constraintContext);
                    violations.addAll(v);
                } else {
                    String name3 = this.indexedName("", nestedName, i++);
                    ConstraintViolation v = this.notNullViolation(name3, locale);
                    violations.add(v);
                }
                if (violations.isEmpty() || !this.failFast && !((Validator)validator).isFailFast()) continue;
                return violations;
            }
        }
        for (Pair pair : this.conditionalValidators) {
            ConstraintCondition condition = (ConstraintCondition)pair.first();
            if (!condition.test(target, constraintContext)) continue;
            validator = this.failFast ? ((Validatable)pair.second()).failFast(true) : (Validatable)pair.second();
            ConstraintViolations constraintViolations = validator.validate(target, locale, constraintContext);
            for (ConstraintViolation violation : constraintViolations) {
                ConstraintViolation renamed = violation.rename(name -> this.prefix + this.indexedName((String)name, collectionName, index));
                violations.add(renamed);
                if (violations.isEmpty() || !this.failFast && !validator.isFailFast()) continue;
                return violations;
            }
        }
        return violations;
    }

    private ConstraintViolation notNullViolation(String name, Locale locale) {
        return ConstraintViolation.builder().name(name).messageKey(ViolationMessage.Default.OBJECT_NOT_NULL.messageKey()).defaultMessageFormat(ViolationMessage.Default.OBJECT_NOT_NULL.defaultMessageFormat()).argsWithPrependedName(new Object[0]).messageFormatter(this.messageFormatter).locale(locale).build();
    }
}

