/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.core;

import am.ik.yavi.core.ConstraintContext;
import am.ik.yavi.core.ConstraintGroup;
import am.ik.yavi.core.ConstraintViolations;
import am.ik.yavi.core.ConstraintViolationsException;
import am.ik.yavi.core.ErrorHandler;
import am.ik.yavi.core.Validated;
import am.ik.yavi.fn.Validation;
import am.ik.yavi.jsr305.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface ValueValidator<T, X> {
    public Validated<X> validate(@Nullable T var1, Locale var2, ConstraintContext var3);

    public static <X> ValueValidator<X, X> passThrough() {
        return (x, locale, constraintContext) -> Validated.of(Validation.success(x));
    }

    default public <X2> ValueValidator<T, X2> andThen(Function<? super X, ? extends X2> mapper) {
        return (t, locale, constraintContext) -> (Validated)this.validate(t, locale, constraintContext).map(mapper);
    }

    default public <X2> ValueValidator<T, X2> andThen(ValueValidator<? super X, X2> validator) {
        return (t, locale, constraintContext) -> this.validate(t, locale, constraintContext).flatMap(v -> validator.validate((Object)v, locale, constraintContext));
    }

    default public <A> ValueValidator<A, X> compose(Function<? super A, ? extends T> mapper) {
        return (a, locale, constraintContext) -> this.validate(mapper.apply((Object)a), locale, constraintContext);
    }

    default public Validated<X> validate(@Nullable T t) {
        return this.validate(t, Locale.getDefault(), ConstraintGroup.DEFAULT);
    }

    default public Validated<X> validate(@Nullable T t, ConstraintContext constraintContext) {
        return this.validate(t, Locale.getDefault(), constraintContext);
    }

    default public Validated<X> validate(@Nullable T t, Locale locale) {
        return this.validate(t, locale, ConstraintGroup.DEFAULT);
    }

    default public X validated(@Nullable T t) throws ConstraintViolationsException {
        return (X)this.validate(t).orElseThrow(ConstraintViolationsException::new);
    }

    default public X validated(@Nullable T t, ConstraintContext constraintContext) throws ConstraintViolationsException {
        return (X)this.validate(t, constraintContext).orElseThrow(ConstraintViolationsException::new);
    }

    default public X validated(@Nullable T t, Locale locale) throws ConstraintViolationsException {
        return (X)this.validate(t, locale).orElseThrow(ConstraintViolationsException::new);
    }

    default public X validated(@Nullable T t, Locale locale, ConstraintContext constraintContext) throws ConstraintViolationsException {
        return (X)this.validate(t, locale, constraintContext).orElseThrow(ConstraintViolationsException::new);
    }

    default public ValueValidator<T, X> indexed(int index) {
        return (t, locale, constraintContext) -> this.validate(t, locale, constraintContext).indexed(index);
    }

    default public <C extends Collection<X>> ValueValidator<Iterable<T>, C> liftCollection(Supplier<C> factory) {
        return (values, locale, constraintContext) -> Validated.traverseIndexed(values, (v, index) -> this.indexed(index).validate(v, locale, constraintContext), factory);
    }

    default public ValueValidator<Iterable<T>, List<X>> liftList() {
        return ValueValidator.liftList(this);
    }

    default public ValueValidator<Iterable<T>, Set<X>> liftSet() {
        return ValueValidator.liftSet(this);
    }

    default public ValueValidator<Optional<T>, Optional<X>> liftOptional() {
        return ValueValidator.liftOptional(this);
    }

    public static <A1, R, C extends Collection<R>> ValueValidator<Iterable<A1>, C> liftCollection(ValueValidator<? super A1, ? extends R> validator, Supplier<C> factory) {
        return (values, locale, constraintContext) -> Validated.traverseIndexed(values, (v, index) -> validator.indexed(index).validate(v, locale, constraintContext), factory);
    }

    public static <A1, R> ValueValidator<Iterable<A1>, List<R>> liftList(ValueValidator<? super A1, ? extends R> validator) {
        return ValueValidator.liftCollection(validator, ArrayList::new);
    }

    public static <A1, R> ValueValidator<Iterable<A1>, Set<R>> liftSet(ValueValidator<? super A1, ? extends R> validator) {
        return ValueValidator.liftCollection(validator, LinkedHashSet::new);
    }

    public static <A1, R> ValueValidator<Optional<A1>, Optional<R>> liftOptional(ValueValidator<? super A1, ? extends R> validator) {
        return (value, locale, constraintContext) -> Validated.traverseOptional(value, v -> validator.validate((Object)v, locale, constraintContext));
    }

    default public <E> BiConsumer<T, E> toBiConsumer(ErrorHandler<E> errorHandler) {
        return (target, errors) -> {
            Validated<X> validated = this.validate(target);
            if (!validated.isValid()) {
                ConstraintViolations violations = validated.errors();
                violations.apply((name, messageKey, args, defaultMessage) -> errorHandler.handleError(errors, name, messageKey, args, defaultMessage));
            }
        };
    }
}

