/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.fn;

import am.ik.yavi.fn.Combining2;
import am.ik.yavi.fn.Function1;
import am.ik.yavi.jsr305.Nullable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class Validation<E, T>
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract boolean isValid();

    public abstract T value();

    @Nullable
    public abstract T valueNullable();

    public abstract List<E> errors();

    public <T2, V extends Validation<E, T2>> V map(Function<? super T, ? extends T2> mapper) {
        return (V)(this.isValid() ? this.yieldSuccess(mapper.apply(this.value())) : this);
    }

    public <T2, V extends Validation<E, T2>> V flatMap(Function<? super T, V> mapper) {
        return (V)(this.isValid() ? (Validation)mapper.apply(this.value()) : this);
    }

    public Validation<E, T> peek(Consumer<? super T> consumer) {
        if (this.isValid()) {
            consumer.accept(this.value());
        }
        return this;
    }

    public <E2> Validation<E2, T> mapErrors(Function<? super List<E>, ? extends List<E2>> errorsMapper) {
        return this.isValid() ? this : Validation.failure(errorsMapper.apply(this.errors()));
    }

    public <E2> Validation<E2, T> mapError(Function<? super E, ? extends E2> errorMapper) {
        return this.isValid() ? this : Validation.failure(this.errors().stream().map(errorMapper).collect(Collectors.toList()));
    }

    public <E2, T2> Validation<E2, T2> bimap(Function<? super List<E>, ? extends List<E2>> errorsMapper, Function<? super T, ? extends T2> mapper) {
        return this.isValid() ? Validation.success(mapper.apply(this.value())) : Validation.failure(errorsMapper.apply(this.errors()));
    }

    public Validation<E, T> peekErrors(Consumer<? super List<E>> consumer) {
        if (!this.isValid()) {
            consumer.accept(this.errors());
        }
        return this;
    }

    public <X extends Throwable> T orElseThrow(Function<? super List<E>, ? extends X> exceptionMapper) throws X {
        if (this.isValid()) {
            return this.value();
        }
        throw (Throwable)exceptionMapper.apply(this.errors());
    }

    public <X extends Throwable> void throwIfInvalid(Function<? super List<E>, ? extends X> exceptionMapper) throws X {
        if (!this.isValid()) {
            throw (Throwable)exceptionMapper.apply(this.errors());
        }
    }

    public T orElseGet(Function<? super List<E>, ? extends T> other) {
        if (this.isValid()) {
            return this.value();
        }
        return other.apply(this.errors());
    }

    public <U> U fold(Function<? super List<E>, ? extends U> errorsMapper, Function<? super T, ? extends U> mapper) {
        return this.isValid() ? mapper.apply(this.value()) : errorsMapper.apply(this.errors());
    }

    protected <U, V extends Validation<E, U>> V yieldSuccess(@Nullable U value) {
        return (V)Validation.success(value);
    }

    protected <U, V extends Validation<E, U>> V yieldFailure(List<E> errors) {
        return (V)Validation.failure(errors);
    }

    public <U, V extends Validation<E, U>> V apply(Validation<E, ? extends Function1<? super T, ? extends U>> validation) {
        if (this.isValid()) {
            if (validation.isValid()) {
                Function1<? super T, ? extends U> f = validation.valueNullable();
                U u = f == null ? null : (U)f.apply((T)this.valueNullable());
                return this.yieldSuccess(u);
            }
            List<E> errors = validation.errors();
            return this.yieldFailure(errors);
        }
        List<E> errors = this.errors();
        if (validation.isValid()) {
            return this.yieldFailure(errors);
        }
        ArrayList<E> errorsList = new ArrayList<E>(validation.errors());
        errorsList.addAll(errors);
        return this.yieldFailure(errorsList);
    }

    public <T2> Combining2<E, T, T2> combine(Validation<E, T2> validation) {
        return new Combining2(this, validation);
    }

    public static <E, T> Validation<E, T> success(@Nullable T value) {
        return new Success(value);
    }

    public static <E, T> Validation<E, T> failure(List<E> errors) {
        return new Failure(errors);
    }

    public static <E, T> Validation<E, T> failure(E ... errors) {
        return new Failure(Arrays.asList(errors));
    }

    public static class Failure<E, T>
    extends Validation<E, T> {
        private static final long serialVersionUID = 1L;
        private final List<E> errors;

        Failure(List<E> errors) {
            if (errors == null) {
                throw new IllegalArgumentException("'errors' must not be null.");
            }
            if (errors.isEmpty()) {
                throw new IllegalArgumentException("'errors' must not be empty.");
            }
            this.errors = Collections.unmodifiableList(errors);
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public T value() {
            throw new NoSuchElementException("value of 'Failure' Validation does not exists. Errors=" + this.errors);
        }

        @Override
        public T valueNullable() {
            return this.value();
        }

        @Override
        public List<E> errors() {
            return this.errors;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure = (Failure)o;
            return this.errors.equals(failure.errors);
        }

        public int hashCode() {
            return Objects.hash(this.errors);
        }
    }

    public static class Success<E, T>
    extends Validation<E, T> {
        private static final long serialVersionUID = 1L;
        public final T value;

        Success(@Nullable T value) {
            this.value = value;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public T value() {
            if (this.value == null) {
                throw new NoSuchElementException("'value' is null.");
            }
            return this.value;
        }

        @Override
        public T valueNullable() {
            return this.value;
        }

        @Override
        public List<E> errors() throws RuntimeException {
            throw new NoSuchElementException("errors of 'Success' Validation does not exist.");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Success success = (Success)o;
            return Objects.equals(this.value, success.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

