/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.processor;

import am.ik.yavi.fn.Pair;
import am.ik.yavi.meta.ConstraintArguments;
import am.ik.yavi.meta.ConstraintTarget;
import am.ik.yavi.processor.ConstraintMetaTemplate;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"am.ik.yavi.meta.ConstraintTarget", "am.ik.yavi.meta.ConstraintArguments"})
public class ConstraintMetaProcessor
extends AbstractProcessor {
    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Name qualifiedName = typeElement.getQualifiedName();
            if (qualifiedName.contentEquals(ConstraintTarget.class.getName())) {
                this.processConstraintTarget(typeElement, roundEnv);
            }
            if (!qualifiedName.contentEquals(ConstraintArguments.class.getName())) continue;
            this.processConstraintArguments(typeElement, roundEnv);
        }
        return true;
    }

    private void processConstraintTarget(TypeElement typeElement, RoundEnvironment roundEnv) {
        Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(typeElement);
        Map elementsMap = elementsAnnotatedWith.stream().filter(x -> !(x instanceof ExecutableElement) || ((ExecutableElement)x).getTypeParameters().isEmpty()).map(x -> new Pair<Element, Integer>((Element)x, -1)).collect(Collectors.groupingBy(k -> {
            String className = "****";
            Element element = (Element)k.first();
            if (element instanceof VariableElement) {
                className = element.getEnclosingElement().getEnclosingElement().toString();
            } else if (element instanceof ExecutableElement) {
                className = element.getEnclosingElement().toString();
            }
            return className;
        }, Collectors.toList()));
        if (elementsMap.isEmpty()) {
            return;
        }
        elementsMap.forEach(this::writeConstraintMetaFile);
    }

    private void processConstraintArguments(TypeElement typeElement, RoundEnvironment roundEnv) {
        Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(typeElement);
        for (Element element : elementsAnnotatedWith) {
            ArrayList<? extends VariableElement> parameters = new ArrayList<VariableElement>(((ExecutableElement)element).getParameters());
            String className = element.getEnclosingElement().toString();
            if (element.getKind() == ElementKind.METHOD) {
                parameters.add(0, (VariableElement)element.getEnclosingElement());
                className = className + ConstraintMetaProcessor.beanUpperCamel(element.getSimpleName().toString());
            }
            String argumentsClass = "am.ik.yavi.arguments.Arguments" + parameters.size() + "<" + parameters.stream().map(x -> ConstraintMetaProcessor.type(x.asType())).collect(Collectors.joining(", ")) + ">";
            List<Pair<Element, Integer>> pairs = parameters.stream().map(x -> new Pair<Element, Integer>((Element)x, parameters.indexOf(x))).collect(Collectors.toList());
            this.writeConstraintArgumentMetaFile(className + "Arguments", argumentsClass, pairs);
        }
    }

    private void writeConstraintMetaFile(String className, List<Pair<Element, Integer>> elements) {
        this.writeMetaFile(className, elements, (pair, metas) -> {
            Element element = (Element)pair.first();
            ConstraintTarget constraintTarget = element.getAnnotation(ConstraintTarget.class);
            ElementKind kind = element.getKind();
            String name = element.getSimpleName().toString();
            if (kind == ElementKind.METHOD) {
                TypeMirror type = ((ExecutableElement)element).getReturnType();
                String target = ConstraintMetaProcessor.beanLowerCamel(constraintTarget.getter() ? name.replaceFirst("^" + ConstraintMetaProcessor.getterPrefix(type), "") : name);
                metas.put(target, ConstraintMetaTemplate.template(className, ConstraintMetaProcessor.type(type), target, name, constraintTarget.field()));
            } else if (kind == ElementKind.PARAMETER) {
                TypeMirror type = element.asType();
                String method = constraintTarget.getter() ? ConstraintMetaProcessor.getterPrefix(type) + ConstraintMetaProcessor.beanUpperCamel(name) : name;
                metas.put(name, ConstraintMetaTemplate.template(className, ConstraintMetaProcessor.type(type), name, method, constraintTarget.field()));
            }
        });
    }

    private void writeConstraintArgumentMetaFile(String className, String argumentsClass, List<Pair<Element, Integer>> elements) {
        this.writeMetaFile(className, elements, (pair, metas) -> {
            Element element = (Element)pair.first();
            TypeMirror type = element.asType();
            int position = (Integer)pair.second() + 1;
            String name = element.getSimpleName().toString();
            metas.put(name, ConstraintMetaTemplate.templateArgument(argumentsClass, ConstraintMetaProcessor.type(type), element.getKind() == ElementKind.CLASS ? ConstraintMetaProcessor.beanLowerCamel(name) : name, position));
        });
    }

    private void writeMetaFile(String className, List<Pair<Element, Integer>> elements, BiConsumer<Pair<Element, Integer>, Map<String, String>> processElement) {
        Pair<String, String> pair = ConstraintMetaProcessor.splitClassName(className);
        String packageName = pair.first();
        String simpleClassName = pair.second();
        String metaSimpleClassName = "_" + simpleClassName.replace('.', '_') + "Meta";
        String metaClassName = packageName + "." + metaSimpleClassName;
        try {
            JavaFileObject builderFile = this.processingEnv.getFiler().createSourceFile(metaClassName, new Element[0]);
            try (PrintWriter out = new PrintWriter(builderFile.openWriter());){
                if (!packageName.isEmpty()) {
                    out.print("package ");
                    out.print(packageName);
                    out.println(";");
                    out.println();
                }
                out.println("// Generated at " + OffsetDateTime.now());
                out.print("public class ");
                out.print(metaSimpleClassName);
                out.println(" {");
                LinkedHashMap<String, String> metas = new LinkedHashMap<String, String>();
                for (Pair<Element, Integer> element : elements) {
                    processElement.accept(element, metas);
                }
                metas.forEach((k, v) -> out.println("  " + v + ";"));
                out.println("}");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static Pair<String, String> splitClassName(String className) {
        String packageName = "";
        int p = ConstraintMetaProcessor.firstUpperPosition(className);
        if (p > 0) {
            packageName = className.substring(0, p - 1);
        }
        String simpleClassName = className.substring(p);
        return new Pair<String, String>(packageName, simpleClassName);
    }

    static int firstUpperPosition(String s) {
        String lower = s.toLowerCase();
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == lower.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    static String getterPrefix(TypeMirror type) {
        return type.getKind() == TypeKind.BOOLEAN ? "is" : "get";
    }

    static String type(TypeMirror typeMirror) {
        TypeKind kind = typeMirror.getKind();
        if (kind.isPrimitive()) {
            if (kind == TypeKind.BOOLEAN) {
                return Boolean.class.getName();
            }
            if (kind == TypeKind.BYTE) {
                return Byte.class.getName();
            }
            if (kind == TypeKind.SHORT) {
                return Short.class.getName();
            }
            if (kind == TypeKind.INT) {
                return Integer.class.getName();
            }
            if (kind == TypeKind.LONG) {
                return Long.class.getName();
            }
            if (kind == TypeKind.CHAR) {
                return Character.class.getName();
            }
            if (kind == TypeKind.FLOAT) {
                return Float.class.getName();
            }
            if (kind == TypeKind.DOUBLE) {
                return Double.class.getName();
            }
        }
        return typeMirror.toString();
    }

    static String beanLowerCamel(String s) {
        String firstTwo;
        if (s.length() >= 2 && (firstTwo = s.substring(0, 2)).equals(firstTwo.toUpperCase())) {
            return s;
        }
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    static String beanUpperCamel(String s) {
        String firstTwo;
        if (s.length() >= 2 && (firstTwo = s.substring(0, 2)).equals(firstTwo.toUpperCase())) {
            return s;
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }
}

