/*
 * Decompiled with CFR 0.152.
 */
package am.ik.yavi.processor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.HashSet;
import java.util.Set;

class ConstraintMetaTemplate {
    private static final Set<String> supportedTypes = new HashSet<String>(){
        {
            this.add(BigDecimal.class.getName());
            this.add(BigInteger.class.getName());
            this.add(Boolean.class.getName());
            this.add(Byte.class.getName());
            this.add(Character.class.getName());
            this.add(Double.class.getName());
            this.add(Float.class.getName());
            this.add(Integer.class.getName());
            this.add(Long.class.getName());
            this.add(Short.class.getName());
            this.add(String.class.getName());
            this.add(LocalDate.class.getName());
            this.add(LocalTime.class.getName());
            this.add(LocalDateTime.class.getName());
            this.add(OffsetDateTime.class.getName());
            this.add(ZonedDateTime.class.getName());
            this.add(Instant.class.getName());
        }
    };

    ConstraintMetaTemplate() {
    }

    static String template(String className, String type, String target, String method, boolean useField) {
        String simpleType = ConstraintMetaTemplate.simpleType(type);
        String metaType = "Object".equals(simpleType) ? className + ", " + type : className;
        return String.format("\n\tpublic static final am.ik.yavi.meta.%sConstraintMeta<%s> %s = new am.ik.yavi.meta.%sConstraintMeta<%s>() {\n\n\t\t@Override\n\t\tpublic String name() {\n\t\t\treturn \"%s\";\n\t\t}\n\n\t\t@Override\n\t\tpublic java.util.function.Function<%s, %s> toValue() {\n\t\t\treturn %s;\n\t\t}\n\t}", simpleType, metaType, target.toUpperCase(), simpleType, metaType, target, className, type, useField ? "x  -> x." + target : className + "::" + method);
    }

    static String templateArgument(String className, String type, String target, int position) {
        String simpleType = ConstraintMetaTemplate.simpleType(type);
        String metaType = "Object".equals(simpleType) ? className + ", " + type : className;
        return String.format("\n\tpublic static final am.ik.yavi.meta.%sConstraintMeta<%s> %s = new am.ik.yavi.meta.%sConstraintMeta<%s>() {\n\n\t\t@Override\n\t\tpublic String name() {\n\t\t\treturn \"%s\";\n\t\t}\n\n\t\t@Override\n\t\tpublic java.util.function.Function<%s, %s> toValue() {\n\t\t\treturn %s;\n\t\t}\n\t}", simpleType, metaType, target.toUpperCase(), simpleType, metaType, target, className, type, className.replaceAll("<(.+)>", "") + "::arg" + position);
    }

    private static String simpleType(String type) {
        if (supportedTypes.contains(type)) {
            int lastDot = type.lastIndexOf(46);
            return type.substring(lastDot + 1);
        }
        return "Object";
    }
}

