/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.client;

import com.zenvia.api.sdk.client.exceptions.UnsupportedChannelException;
import com.zenvia.api.sdk.contents.ContentType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum ChannelType {
    whatsapp(ContentType.text, ContentType.file, ContentType.template),
    sms(ContentType.text),
    facebook(ContentType.text, ContentType.file);

    public final String messagePath = "/v1/channels/" + this.name() + "/messages";
    private final Set<ContentType> supportedContentTypes;

    private ChannelType(ContentType ... contentTypes) {
        this.supportedContentTypes = Collections.unmodifiableSet(new HashSet<ContentType>(Arrays.asList(contentTypes)));
    }

    public boolean supportsContent(ContentType contentType) {
        return this.supportedContentTypes.contains((Object)contentType);
    }

    public static ChannelType parse(String channel) throws UnsupportedChannelException {
        try {
            return ChannelType.valueOf(channel);
        }
        catch (RuntimeException exception) {
            throw new UnsupportedChannelException(channel);
        }
    }
}

