/*
 * Decompiled with CFR 0.152.
 */
package com.zenvia.api.sdk.webhook;

import com.zenvia.api.sdk.client.AbstractClient;
import com.zenvia.api.sdk.client.ChannelType;
import com.zenvia.api.sdk.client.subscriptions.Criteria;
import com.zenvia.api.sdk.client.subscriptions.EventType;
import com.zenvia.api.sdk.client.subscriptions.MessageCriteria;
import com.zenvia.api.sdk.client.subscriptions.MessageStatusSubscription;
import com.zenvia.api.sdk.client.subscriptions.MessageSubscription;
import com.zenvia.api.sdk.client.subscriptions.Subscription;
import com.zenvia.api.sdk.client.subscriptions.SubscriptionStatus;
import com.zenvia.api.sdk.client.subscriptions.Webhook;
import com.zenvia.api.sdk.messages.MessageDirection;
import com.zenvia.api.sdk.webhook.MessageEventCallback;
import com.zenvia.api.sdk.webhook.MessageStatusEventCallback;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebhookController {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractWebhookController.class);
    public static final String DEFAULT_PATH = "/";
    protected final MessageEventCallback messageEventHandler;
    protected final MessageStatusEventCallback messageStatusEventHandler;
    protected final String path;
    protected final AbstractClient client;
    protected final String url;
    protected final ChannelType channel;

    public AbstractWebhookController(MessageEventCallback messageEventHandler) {
        this(messageEventHandler, null, null);
    }

    public AbstractWebhookController(MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler) {
        this(messageEventHandler, messageStatusEventHandler, null, null, null, null);
    }

    public AbstractWebhookController(MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler, String path) {
        this(messageEventHandler, messageStatusEventHandler, path, null, null, null);
    }

    public AbstractWebhookController(MessageEventCallback messageEventHandler, String path) {
        this(messageEventHandler, null, path, null, null, null);
    }

    public AbstractWebhookController(MessageStatusEventCallback messageStatusEventHandler) {
        this(null, messageStatusEventHandler, null);
    }

    public AbstractWebhookController(MessageStatusEventCallback messageStatusEventHandler, String path) {
        this(null, messageStatusEventHandler, path);
    }

    public AbstractWebhookController(MessageEventCallback messageEventHandler, AbstractClient client, String url, ChannelType channel) {
        this(messageEventHandler, null, null, client, url, channel);
    }

    public AbstractWebhookController(MessageStatusEventCallback messageStatusEventHandler, AbstractClient client, String url, ChannelType channel) {
        this(null, messageStatusEventHandler, null, client, url, channel);
    }

    public AbstractWebhookController(MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler, AbstractClient client, String url, ChannelType channel) {
        this(messageEventHandler, messageStatusEventHandler, null, client, url, channel);
    }

    public AbstractWebhookController(MessageEventCallback messageEventHandler, MessageStatusEventCallback messageStatusEventHandler, String path, AbstractClient client, String url, ChannelType channel) {
        this.messageEventHandler = messageEventHandler;
        this.messageStatusEventHandler = messageStatusEventHandler;
        this.path = AbstractWebhookController.valueOrDefault(path, DEFAULT_PATH);
        this.client = client;
        this.url = url;
        this.channel = channel;
    }

    public void init() {
        try {
            this.createSubscriptions();
        }
        catch (Exception e) {
            LOG.error("Error on try to create subscription", (Throwable)e);
            throw e;
        }
    }

    private void createSubscriptions() {
        if (this.client == null || this.url == null || this.channel == null || this.messageEventHandler == null && this.messageStatusEventHandler == null) {
            return;
        }
        LOG.debug("Verifying subscriptions before create them if not exist");
        List<Subscription> subscriptions = this.client.listSubscriptions();
        boolean shouldCreateMessageSubscription = true;
        boolean shouldCreateMessageStatusSubscription = true;
        for (Subscription subscription : subscriptions) {
            if (!SubscriptionStatus.ACTIVE.equals((Object)subscription.status) || !this.url.equalsIgnoreCase(subscription.webhook.url) || !this.channel.equals((Object)subscription.criteria.channel)) continue;
            if (EventType.MESSAGE.equals((Object)subscription.eventType)) {
                LOG.debug("It wont be necessary to create subscription for MESSAGE event");
                shouldCreateMessageSubscription = false;
                continue;
            }
            if (!EventType.MESSAGE_STATUS.equals((Object)subscription.eventType)) continue;
            shouldCreateMessageStatusSubscription = false;
            LOG.debug("It wont be necessary to create subscription for MESSAGE_STAUS event");
        }
        if (shouldCreateMessageSubscription || shouldCreateMessageStatusSubscription) {
            Criteria criteria;
            Webhook webhook = new Webhook(this.url);
            if (this.messageEventHandler != null && shouldCreateMessageSubscription) {
                criteria = new MessageCriteria(this.channel, MessageDirection.IN);
                LOG.debug("Trying to create subscription for MESSAGE event of channel {}", (Object)this.channel);
                this.client.createSubscription(new MessageSubscription(webhook, (MessageCriteria)criteria));
            }
            if (this.messageStatusEventHandler != null && shouldCreateMessageStatusSubscription) {
                criteria = new Criteria(this.channel);
                LOG.debug("Trying to create subscription for MESSAGE_STATUS event of channel {}", (Object)this.channel);
                this.client.createSubscription(new MessageStatusSubscription(webhook, criteria));
            }
        }
    }

    private static final <TYPE> TYPE valueOrDefault(TYPE value, TYPE defaultValue) {
        return value == null ? defaultValue : value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{\n  messageEventHandler = [" + this.messageEventHandler + "]\n  messageStatusEventHandler = [" + this.messageStatusEventHandler + "]\n  path = [" + this.path + "]\n  url = [" + this.url + "]\n  channel = [" + (Object)((Object)this.channel) + "]\n  client = [" + this.client + "]\n}";
    }
}

