/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="refNF")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoCTeSubstituicaoTomadorICMSRefernciaNF
extends DFBase {
    private static final long serialVersionUID = 5240924361145981157L;
    @Element(name="CNPJ", required=false)
    private String cnpj = null;
    @Element(name="CPF", required=false)
    private String cpf = null;
    @Element(name="mod")
    private String modelo = null;
    @Element(name="serie")
    private String serie = null;
    @Element(name="subserie", required=false)
    private String subserie = null;
    @Element(name="nro")
    private String numeroDocumento = null;
    @Element(name="valor")
    private String valor = null;
    @Element(name="dEmi")
    private LocalDate dataEmissao = null;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getModelo() {
        return this.modelo;
    }

    public void setModelo(String string) {
        DFStringValidador.exatamente2(string, "Modelo do Documento Fiscal");
        this.modelo = string;
    }

    public String getSerie() {
        return this.serie;
    }

    public void setSerie(String string) {
        DFStringValidador.tamanho3N(string, "Serie do documento fiscal");
        this.serie = string;
    }

    public String getSubserie() {
        return this.subserie;
    }

    public void setSubserie(String string) {
        DFStringValidador.tamanho3N(this.serie, "Subserie do documento fiscal");
        this.subserie = string;
    }

    public String getNumeroDocumento() {
        return this.numeroDocumento;
    }

    public void setNumeroDocumento(String string) {
        DFStringValidador.tamanho6N(string, "N\u00famero do documento fiscal");
        this.numeroDocumento = string;
    }

    public String getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal bigDecimal) {
        this.valor = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor do documento fiscal");
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate localDate) {
        this.dataEmissao = localDate;
    }
}

