/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte300.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte300.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte300.classes.evento.epec.CTeEnviaEventoEpec;
import com.fincatto.documentofiscal.cte300.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSEpec
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "EPEC";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("3.00");
    private static final String EVENTO_EPEC = "110113";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSEpec(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno enviaEpecAssinado(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEventoSVC(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno enviaEpec(String string, CTeEnviaEventoEpec cTeEnviaEventoEpec) throws Exception {
        String string2 = this.getXmlAssinado(string, cTeEnviaEventoEpec);
        return this.enviaEpecAssinado(string, string2);
    }

    String getXmlAssinado(String string, CTeEnviaEventoEpec cTeEnviaEventoEpec) throws Exception {
        String string2 = this.gerarDadosEpec(string, cTeEnviaEventoEpec).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string2);
    }

    private CTeEvento gerarDadosEpec(String string, CTeEnviaEventoEpec cTeEnviaEventoEpec) throws Exception {
        cTeEnviaEventoEpec.setDescricaoEvento(DESCRICAO_EVENTO);
        DFXMLValidador.validaEventoEpecCTe300(cTeEnviaEventoEpec.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoEpec, EVENTO_EPEC, null, 1);
    }
}

