/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.CTTipoDocumento;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="infOutros")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoCTeNormalInfoDocumentosInfoOutros
extends DFBase {
    private static final long serialVersionUID = -1108430703882605623L;
    @Element(name="tpDoc")
    private CTTipoDocumento tipoDocumento;
    @Element(name="descOutros", required=false)
    private String descricao;
    @Element(name="nDoc", required=false)
    private String numero;
    @Element(name="dEmi", required=false)
    private LocalDate dataEmissao;
    @Element(name="vDocFisc", required=false)
    private String valorDocumentoFiscal;
    @Element(name="dPrev", required=false)
    private LocalDate dataPrevisaoEntrega;
    @ElementList(name="infUnidCarga", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> infoUnidCarga;
    @ElementList(name="infUnidTransp", inline=true, required=false)
    private List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> infoUnidTransporte;

    public CTTipoDocumento getTipoDocumento() {
        return this.tipoDocumento;
    }

    public void setTipoDocumento(CTTipoDocumento cTTipoDocumento) {
        this.tipoDocumento = cTTipoDocumento;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String string) {
        DFStringValidador.tamanho100(string, "Descri\u00e7\u00e3o do documento");
        this.descricao = string;
    }

    public String getNumero() {
        return this.numero;
    }

    public void setNumero(String string) {
        DFStringValidador.tamanho20(string, "N\u00famero documento");
        this.numero = string;
    }

    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    public void setDataEmissao(LocalDate localDate) {
        this.dataEmissao = localDate;
    }

    public String getValorDocumentoFiscal() {
        return this.valorDocumentoFiscal;
    }

    public void setValorDocumentoFiscal(BigDecimal bigDecimal) {
        this.valorDocumentoFiscal = DFBigDecimalValidador.tamanho15Com2CasasDecimais(bigDecimal, "Valor do documento");
    }

    public LocalDate getDataPrevisaoEntrega() {
        return this.dataPrevisaoEntrega;
    }

    public void setDataPrevisaoEntrega(LocalDate localDate) {
        this.dataPrevisaoEntrega = localDate;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> getInfoUnidCarga() {
        return this.infoUnidCarga;
    }

    public void setInfoUnidCarga(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeCarga> list) {
        this.infoUnidCarga = list;
    }

    public List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> getInfoUnidTransporte() {
        return this.infoUnidTransporte;
    }

    public void setInfoUnidTransporte(List<CTeNotaInfoCTeNormalInfoDocumentosInfoUnidadeTransporte> list) {
        this.infoUnidTransporte = list;
    }
}

