/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.cte400.classes.CTTipoRegimeTributario;
import com.fincatto.documentofiscal.cte400.classes.nota.CTeNotaEnderecoEmitente;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Namespace;
import org.simpleframework.xml.Root;

@Root(name="emit")
@Namespace(reference="http://www.portalfiscal.inf.br/cte")
public class CTeNotaInfoEmitente
extends DFBase {
    private static final long serialVersionUID = 7416168996867090127L;
    @Element(name="CNPJ")
    private String cnpj;
    @Element(name="IE")
    private String inscricaoEstadual;
    @Element(name="IEST", required=false)
    private String inscricaoEstadualST;
    @Element(name="xNome")
    private String razaoSocial;
    @Element(name="xFant", required=false)
    private String nomeFantasia;
    @Element(name="enderEmit")
    private CTeNotaEnderecoEmitente endereco;
    @Element(name="CRT")
    private CTTipoRegimeTributario tipoRegimeTributario;

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    public void setInscricaoEstadual(String string) {
        DFStringValidador.inscricaoEstadualSemIsencao(string);
        this.inscricaoEstadual = string;
    }

    public String getInscricaoEstadualST() {
        return this.inscricaoEstadualST;
    }

    public void setInscricaoEstadualST(String string) {
        DFStringValidador.tamanho14N(string, "Inscri\u00e7\u00e3o Estadual do Substituto Tribut\u00e1rio");
        this.inscricaoEstadualST = string;
    }

    public String getRazaoSocial() {
        return this.razaoSocial;
    }

    public void setRazaoSocial(String string) {
        DFStringValidador.tamanho2ate60(string, "Raz\u00e3o social ou Nome do emitente");
        this.razaoSocial = string;
    }

    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    public void setNomeFantasia(String string) {
        DFStringValidador.tamanho2ate60(string, "Nome fantasia");
        this.nomeFantasia = string;
    }

    public CTeNotaEnderecoEmitente getEnderEmit() {
        return this.endereco;
    }

    public void setEnderEmit(CTeNotaEnderecoEmitente cTeNotaEnderecoEmitente) {
        this.endereco = cTeNotaEnderecoEmitente;
    }

    public CTTipoRegimeTributario getTipoRegimeTributario() {
        return this.tipoRegimeTributario;
    }

    public CTeNotaInfoEmitente setTipoRegimeTributario(CTTipoRegimeTributario cTTipoRegimeTributario) {
        this.tipoRegimeTributario = cTTipoRegimeTributario;
        return this;
    }
}

