/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.cancelamento.CTeEnviaEventoCancelamento;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSCancelamento
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Cancelamento";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_CANCELAMENTO = "110111";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE, DFModelo.CTeOS);

    WSCancelamento(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno cancelaNotaAssinada(String string, String string2) throws Exception {
        OMElement oMElement = super.efetuaEvento(string2, string, VERSAO_LEIAUTE);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno cancelaNota(String string, String string2, String string3) throws Exception {
        String string4 = this.getXmlAssinado(string, string2, string3);
        return this.cancelaNotaAssinada(string, string4);
    }

    String getXmlAssinado(String string, String string2, String string3) throws Exception {
        String string4 = this.gerarDadosCancelamento(string, string2, string3).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string4);
    }

    private CTeEvento gerarDadosCancelamento(String string, String string2, String string3) throws Exception {
        CTeEnviaEventoCancelamento cTeEnviaEventoCancelamento = new CTeEnviaEventoCancelamento();
        cTeEnviaEventoCancelamento.setDescricaoEvento(DESCRICAO_EVENTO);
        cTeEnviaEventoCancelamento.setJustificativa(string3.trim());
        cTeEnviaEventoCancelamento.setProtocoloAutorizacao(string2);
        DFXMLValidador.validaEventoCancelamentoCTe400(cTeEnviaEventoCancelamento.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoCancelamento, EVENTO_CANCELAMENTO, null, 1);
    }
}

