/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEventoRetorno;
import com.fincatto.documentofiscal.cte400.classes.evento.comprovanteentrega.CTeEnviaEventoComprovanteEntrega;
import com.fincatto.documentofiscal.cte400.webservices.WSRecepcaoEvento;
import com.fincatto.documentofiscal.utils.DFAssinaturaDigital;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;

class WSComprovanteEntrega
extends WSRecepcaoEvento {
    private static final String DESCRICAO_EVENTO = "Comprovante de Entrega do CT-e";
    private static final BigDecimal VERSAO_LEIAUTE = new BigDecimal("4.00");
    private static final String EVENTO_COMPROVANTE_DE_ENTREGA = "110180";
    private static final List<DFModelo> modelosPermitidos = Arrays.asList(DFModelo.CTE);

    WSComprovanteEntrega(CTeConfig cTeConfig) {
        super(cTeConfig, modelosPermitidos);
    }

    CTeEventoRetorno comprovanteEntregaAssinado(String string, String string2) throws Exception {
        OMElement oMElement = this.efetuaComprovanteEntrega(string2, string);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    CTeEventoRetorno comprovanteEntrega(String string, CTeEnviaEventoComprovanteEntrega cTeEnviaEventoComprovanteEntrega, int n) throws Exception {
        String string2 = this.getXmlAssinado(string, cTeEnviaEventoComprovanteEntrega, n);
        OMElement oMElement = this.efetuaComprovanteEntrega(string2, string);
        return (CTeEventoRetorno)this.config.getPersister().read(CTeEventoRetorno.class, oMElement.toString());
    }

    String getXmlAssinado(String string, CTeEnviaEventoComprovanteEntrega cTeEnviaEventoComprovanteEntrega, int n) throws Exception {
        String string2 = this.gerarDadosComprovanteEntrega(string, cTeEnviaEventoComprovanteEntrega, n).toString();
        return new DFAssinaturaDigital(this.config).assinarDocumento(string2);
    }

    private OMElement efetuaComprovanteEntrega(String string, String string2) throws Exception {
        return super.efetuaEvento(string, string2, VERSAO_LEIAUTE);
    }

    private CTeEvento gerarDadosComprovanteEntrega(String string, CTeEnviaEventoComprovanteEntrega cTeEnviaEventoComprovanteEntrega, int n) throws Exception {
        cTeEnviaEventoComprovanteEntrega.setDescricaoEvento(DESCRICAO_EVENTO);
        DFXMLValidador.validaEventoComprovanteEntregaCTe400(cTeEnviaEventoComprovanteEntrega.toString());
        return super.gerarEvento(string, VERSAO_LEIAUTE, cTeEnviaEventoComprovanteEntrega, EVENTO_COMPROVANTE_DE_ENTREGA, null, n);
    }
}

