/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.cte400.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.cte.CTeConfig;
import com.fincatto.documentofiscal.cte400.classes.CTAutorizador400;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeDetalhamentoEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeInfoEvento;
import com.fincatto.documentofiscal.cte400.classes.evento.CTeTipoEvento;
import com.fincatto.documentofiscal.cte400.parsers.CTChaveParser;
import com.fincatto.documentofiscal.cte400.webservices.gerado.CTeRecepcaoEventoV4Stub;
import com.fincatto.documentofiscal.validadores.DFXMLValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

abstract class WSRecepcaoEvento
implements DFLog {
    protected final CTeConfig config;
    private final List<DFModelo> modelosPermitidos;

    WSRecepcaoEvento(CTeConfig cTeConfig, List<DFModelo> list) {
        this.config = cTeConfig;
        this.modelosPermitidos = list;
    }

    protected OMElement efetuaEvento(String string, String string2, BigDecimal bigDecimal) throws Exception {
        return this.efetuaEvento(string, string2, bigDecimal, false);
    }

    protected OMElement efetuaEventoSVC(String string, String string2, BigDecimal bigDecimal) throws Exception {
        return this.efetuaEvento(string, string2, bigDecimal, true);
    }

    protected OMElement efetuaEvento(String string, String string2, BigDecimal bigDecimal, boolean bl) throws Exception {
        CTChaveParser cTChaveParser = new CTChaveParser(string2);
        if (!this.modelosPermitidos.contains((Object)cTChaveParser.getModelo())) {
            throw new IllegalArgumentException("CT-e do modelo \"" + cTChaveParser.getModelo().toString() + "\" n\u00e3o \u00e9 permitido nesse evento.");
        }
        DFXMLValidador.validaEventoCTe400(string);
        CTeRecepcaoEventoV4Stub.CteDadosMsg cteDadosMsg = new CTeRecepcaoEventoV4Stub.CteDadosMsg();
        OMElement oMElement = AXIOMUtil.stringToOM((String)string);
        this.getLogger().debug(oMElement.toString());
        cteDadosMsg.setExtraElement(oMElement);
        CTAutorizador400 cTAutorizador400 = bl ? CTAutorizador400.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF()) : CTAutorizador400.valueOfChaveAcesso(string2);
        String string3 = cTAutorizador400.getRecepcaoEvento(this.config.getAmbiente());
        if (string3 == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RecepcaoEvento " + cTChaveParser.getModelo().name() + ", autorizador " + cTAutorizador400.name());
        }
        CTeRecepcaoEventoV4Stub.CteRecepcaoEventoResult cteRecepcaoEventoResult = new CTeRecepcaoEventoV4Stub(string3, this.config).cteRecepcaoEvento(cteDadosMsg);
        OMElement oMElement2 = cteRecepcaoEventoResult.getExtraElement();
        this.getLogger().debug(oMElement2.toString());
        return oMElement2;
    }

    protected CTeEvento gerarEvento(String string, BigDecimal bigDecimal, CTeTipoEvento cTeTipoEvento, String string2, String string3, int n) throws Exception {
        CTChaveParser cTChaveParser = new CTChaveParser(string);
        CTeDetalhamentoEvento cTeDetalhamentoEvento = new CTeDetalhamentoEvento();
        cTeDetalhamentoEvento.setVersaoEvento(bigDecimal);
        cTeDetalhamentoEvento.setEvento(cTeTipoEvento);
        CTeInfoEvento cTeInfoEvento = new CTeInfoEvento();
        cTeInfoEvento.setAmbiente(this.config.getAmbiente());
        cTeInfoEvento.setChave(string);
        if (string3 != null) {
            if (string3.length() == 11) {
                cTeInfoEvento.setCpf(string3);
            } else {
                cTeInfoEvento.setCnpj(string3);
            }
        } else {
            cTeInfoEvento.setCnpj(cTChaveParser.getCnpjEmitente());
        }
        cTeInfoEvento.setDataHoraEvento(ZonedDateTime.now(this.config.getTimeZone().toZoneId()));
        cTeInfoEvento.setNumeroSequencialEvento(n);
        cTeInfoEvento.setId(String.format("ID%s%s%03d", string2, string, n));
        cTeInfoEvento.setOrgao(cTChaveParser.getNFUnidadeFederativa());
        cTeInfoEvento.setCodigoEvento(string2);
        cTeInfoEvento.setDetalheEvento(cTeDetalhamentoEvento);
        CTeEvento cTeEvento = new CTeEvento();
        cTeEvento.setInfoEvento(cTeInfoEvento);
        cTeEvento.setVersao(bigDecimal);
        return cTeEvento;
    }
}

