/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFBigIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemExportacaoIndireta
extends DFBase {
    private static final long serialVersionUID = 2911935204123851926L;
    @Element(name="nRE")
    private BigInteger numeroRegistroExportacao;
    @Element(name="chNFe")
    private String chaveAcessoNFe;
    @Element(name="qExport")
    private String quantidadeItemEfetivamenteExportado;

    public void setChaveAcessoNFe(String string) {
        DFStringValidador.exatamente44N(string, "Chave de Acesso NFe");
        this.chaveAcessoNFe = string;
    }

    public void setNumeroRegistroExportacao(BigInteger bigInteger) {
        DFBigIntegerValidador.tamanho12(bigInteger, "Numero Registro Exportacao");
        this.numeroRegistroExportacao = bigInteger;
    }

    public void setQuantidadeItemEfetivamenteExportado(BigDecimal bigDecimal) {
        this.quantidadeItemEfetivamenteExportado = DFBigDecimalValidador.tamanho15comAte4CasasDecimais(bigDecimal, "Quantidade Item Evetivamente Exportado");
    }

    public String getChaveAcessoNFe() {
        return this.chaveAcessoNFe;
    }

    public BigInteger getNumeroRegistroExportacao() {
        return this.numeroRegistroExportacao;
    }

    public String getQuantidadeItemEfetivamenteExportado() {
        return this.quantidadeItemEfetivamenteExportado;
    }
}

