/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.classes.nota;

import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemProdutoCombustivelCIDE;
import com.fincatto.documentofiscal.nfe310.classes.nota.NFNotaInfoItemProdutoCombustivelEncerrante;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import org.simpleframework.xml.Element;

public class NFNotaInfoItemProdutoCombustivel
extends DFBase {
    private static final long serialVersionUID = -2899516480924530882L;
    @Element(name="cProdANP")
    private String codigoProdutoANP = null;
    @Element(name="pMixGN", required=false)
    private String percentualGasNatural;
    @Element(name="CODIF", required=false)
    private String codigoAutorizacaoCOFIF = null;
    @Element(name="qTemp", required=false)
    private String quantidade = null;
    @Element(name="UFCons")
    private String uf = null;
    @Element(name="CIDE", required=false)
    private NFNotaInfoItemProdutoCombustivelCIDE cide = null;
    @Element(name="encerrante", required=false)
    private NFNotaInfoItemProdutoCombustivelEncerrante encerrante = null;

    public void setCodigoProdutoANP(String string) {
        DFStringValidador.exatamente9(string, "Codigo Produto ANP Combustivel");
        this.codigoProdutoANP = string;
    }

    public void setCodigoAutorizacaoCODIF(String string) {
        DFStringValidador.tamanho21(string, "Codigo Autorizacao CODIF Combustivel");
        this.codigoAutorizacaoCOFIF = string;
    }

    public void setQuantidade(BigDecimal bigDecimal) {
        this.quantidade = DFBigDecimalValidador.tamanho16Com4CasasDecimais(bigDecimal, "Quantidade Combustivel");
    }

    public void setUf(DFUnidadeFederativa dFUnidadeFederativa) {
        this.uf = dFUnidadeFederativa.getCodigo();
    }

    public void setCide(NFNotaInfoItemProdutoCombustivelCIDE nFNotaInfoItemProdutoCombustivelCIDE) {
        this.cide = nFNotaInfoItemProdutoCombustivelCIDE;
    }

    public void setPercentualGasNatural(BigDecimal bigDecimal) {
        this.percentualGasNatural = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Percentual Gas Natural Combustivel");
    }

    public void setEncerrante(NFNotaInfoItemProdutoCombustivelEncerrante nFNotaInfoItemProdutoCombustivelEncerrante) {
        this.encerrante = nFNotaInfoItemProdutoCombustivelEncerrante;
    }

    public String getCodigoProdutoANP() {
        return this.codigoProdutoANP;
    }

    public String getPercentualGasNatural() {
        return this.percentualGasNatural;
    }

    public String getCodigoAutorizacaoCOFIF() {
        return this.codigoAutorizacaoCOFIF;
    }

    public String getQuantidade() {
        return this.quantidade;
    }

    public String getUf() {
        return this.uf;
    }

    public NFNotaInfoItemProdutoCombustivelCIDE getCide() {
        return this.cide;
    }

    public NFNotaInfoItemProdutoCombustivelEncerrante getEncerrante() {
        return this.encerrante;
    }
}

