/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe310.webservices;

import com.fincatto.documentofiscal.DFLog;
import com.fincatto.documentofiscal.DFModelo;
import com.fincatto.documentofiscal.nfe.NFeConfig;
import com.fincatto.documentofiscal.nfe310.classes.NFAutorizador31;
import com.fincatto.documentofiscal.nfe310.classes.lote.consulta.NFLoteConsulta;
import com.fincatto.documentofiscal.nfe310.classes.lote.consulta.NFLoteConsultaRetorno;
import com.fincatto.documentofiscal.nfe310.webservices.gerado.NfeRetAutorizacaoStub;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.AXIOMUtil;

class WSLoteConsulta
implements DFLog {
    private final NFeConfig config;

    WSLoteConsulta(NFeConfig nFeConfig) {
        this.config = nFeConfig;
    }

    NFLoteConsultaRetorno consultaLote(String string, DFModelo dFModelo) throws Exception {
        OMElement oMElement = AXIOMUtil.stringToOM((String)this.gerarDadosConsulta(string).toString());
        this.getLogger().debug(oMElement.toString());
        OMElement oMElement2 = this.efetuaConsulta(oMElement, dFModelo);
        this.getLogger().debug(oMElement2.toString());
        return (NFLoteConsultaRetorno)this.config.getPersister().read(NFLoteConsultaRetorno.class, oMElement2.toString());
    }

    private OMElement efetuaConsulta(OMElement oMElement, DFModelo dFModelo) throws RemoteException {
        String string;
        NfeRetAutorizacaoStub.NfeCabecMsg nfeCabecMsg = new NfeRetAutorizacaoStub.NfeCabecMsg();
        nfeCabecMsg.setCUF(this.config.getCUF().getCodigoIbge());
        nfeCabecMsg.setVersaoDados(this.config.getVersao());
        NfeRetAutorizacaoStub.NfeCabecMsgE nfeCabecMsgE = new NfeRetAutorizacaoStub.NfeCabecMsgE();
        nfeCabecMsgE.setNfeCabecMsg(nfeCabecMsg);
        NfeRetAutorizacaoStub.NfeDadosMsg nfeDadosMsg = new NfeRetAutorizacaoStub.NfeDadosMsg();
        nfeDadosMsg.setExtraElement(oMElement);
        NFAutorizador31 nFAutorizador31 = NFAutorizador31.valueOfTipoEmissao(this.config.getTipoEmissao(), this.config.getCUF());
        String string2 = string = DFModelo.NFCE.equals((Object)dFModelo) ? nFAutorizador31.getNfceRetAutorizacao(this.config.getAmbiente()) : nFAutorizador31.getNfeRetAutorizacao(this.config.getAmbiente());
        if (string == null) {
            throw new IllegalArgumentException("Nao foi possivel encontrar URL para RetAutorizacao " + dFModelo.name() + ", autorizador " + nFAutorizador31.name());
        }
        NfeRetAutorizacaoStub.NfeRetAutorizacaoLoteResult nfeRetAutorizacaoLoteResult = new NfeRetAutorizacaoStub(string, this.config).nfeRetAutorizacaoLote(nfeDadosMsg, nfeCabecMsgE);
        return nfeRetAutorizacaoLoteResult.getExtraElement();
    }

    private NFLoteConsulta gerarDadosConsulta(String string) {
        NFLoteConsulta nFLoteConsulta = new NFLoteConsulta();
        nFLoteConsulta.setRecibo(string);
        nFLoteConsulta.setAmbiente(this.config.getAmbiente());
        nFLoteConsulta.setVersao(new BigDecimal(this.config.getVersao()));
        return nFLoteConsulta;
    }
}

