/*
 * Decompiled with CFR 0.152.
 */
package com.fincatto.documentofiscal.nfe400.classes.evento.epec;

import com.fincatto.documentofiscal.DFAmbiente;
import com.fincatto.documentofiscal.DFBase;
import com.fincatto.documentofiscal.DFUnidadeFederativa;
import com.fincatto.documentofiscal.nfe400.classes.evento.epec.NFInfoEpec;
import com.fincatto.documentofiscal.validadores.DFBigDecimalValidador;
import com.fincatto.documentofiscal.validadores.DFIntegerValidador;
import com.fincatto.documentofiscal.validadores.DFStringValidador;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Element;

public class NFInfoEventoEpec
extends DFBase {
    @Attribute(name="Id", required=true)
    private String identificador;
    @Element(name="cOrgao", required=true)
    private DFUnidadeFederativa orgao;
    @Element(name="tpAmb", required=true)
    private DFAmbiente ambiente;
    @Element(name="CNPJ", required=false)
    private String cnpj;
    @Element(name="CPF", required=false)
    private String cpf;
    @Element(name="chNFe", required=true)
    private String chave;
    @Element(name="dhEvento", required=true)
    private ZonedDateTime dataHoraEvento;
    @Element(name="tpEvento", required=true)
    private String codigoEvento;
    @Element(name="nSeqEvento", required=true)
    private Integer numeroSequencialEvento;
    @Element(name="verEvento", required=true)
    private String versaoEvento;
    @Element(name="detEvento", required=true)
    private NFInfoEpec epec;

    public void setOrgao(DFUnidadeFederativa dFUnidadeFederativa) {
        this.orgao = dFUnidadeFederativa;
    }

    public void setVersaoEvento(BigDecimal bigDecimal) {
        this.versaoEvento = DFBigDecimalValidador.tamanho5Com2CasasDecimais(bigDecimal, "Versao do Evento");
    }

    public String getIdentificador() {
        return this.identificador;
    }

    public void setIdentificador(String string) {
        DFStringValidador.exatamente54(string, "Info Evento Conting\u00eancia EPEC ID");
        this.identificador = string;
    }

    public DFAmbiente getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(DFAmbiente dFAmbiente) {
        this.ambiente = dFAmbiente;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    public void setCnpj(String string) {
        DFStringValidador.cnpj(string);
        this.cnpj = string;
    }

    public String getCpf() {
        return this.cpf;
    }

    public void setCpf(String string) {
        DFStringValidador.cpf(string);
        this.cpf = string;
    }

    public String getChave() {
        return this.chave;
    }

    public void setChave(String string) {
        DFStringValidador.exatamente44N(string, "Info Evento Conting\u00eancia EPEC Chave");
        this.chave = string;
    }

    public ZonedDateTime getDataHoraEvento() {
        return this.dataHoraEvento;
    }

    public void setDataHoraEvento(ZonedDateTime zonedDateTime) {
        this.dataHoraEvento = zonedDateTime;
    }

    public String getCodigoEvento() {
        return this.codigoEvento;
    }

    public void setCodigoEvento(String string) {
        DFStringValidador.exatamente6N(string, "Info Evento Conting\u00eancia EPEC Codigo");
        this.codigoEvento = string;
    }

    public int getNumeroSequencialEvento() {
        return this.numeroSequencialEvento;
    }

    public void setNumeroSequencialEvento(Integer n) {
        DFIntegerValidador.tamanho1a2(n, "Numero Sequencial Evento");
        this.numeroSequencialEvento = n;
    }

    public String getVersaoEvento() {
        return this.versaoEvento;
    }

    public void setVersaoEvento(String string) {
        this.versaoEvento = string;
    }

    public NFInfoEpec getEpec() {
        return this.epec;
    }

    public void setEpec(NFInfoEpec nFInfoEpec) {
        this.epec = nFInfoEpec;
    }

    public DFUnidadeFederativa getOrgao() {
        return this.orgao;
    }
}

